% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ugd.R
\name{ugd}
\alias{ugd}
\alias{dugd}
\alias{pugd}
\alias{qugd}
\alias{rugd}
\title{Uniform-Geometric Distribution}
\usage{
dugd(x, theta, log = FALSE)

pugd(q, theta, lower.tail = TRUE, log.p = FALSE)

qugd(p, theta, lower.tail = TRUE)

rugd(n, theta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{a parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dugd} gives the density, \code{pugd} gives the distribution
function, \code{qugd} gives the quantile function and \code{rugd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the Uniform-Geometric distribution.
}
\details{
The Uniform-Geometric distribution with shape parameter \eqn{\theta}, has
density
\deqn{f\left( x\right) =\theta \left( 1-\theta \right) ^{x-1}LerchPhi
\left[ \left(1-\theta \right) ,1,x\right],}
where
\deqn{LerchPhi\left( z,a,v\right) =\sum_{n=0}^{\infty }\frac{z^{n}}
{\left(v+n\right) ^{a}}}
and
\deqn{x=1,2,...~,~~0<\theta <1.}
}
\examples{
library(new.dist)
dugd(1, theta=0.5)
pugd(1,theta=.5)
qugd(0.6,theta=.1)
rugd(10,theta=.1)
}
\references{
Akdoğan, Y., Kuş, C., Asgharzadeh, A., Kınacı, İ., & Sharafi,
F. (2016).
\emph{Uniform-geometric distribution}. Journal of Statistical Computation and
Simulation, 86(9), 1754-1770.
}
