% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ep_wp_calculators.R
\name{calculate_win_probability}
\alias{calculate_win_probability}
\title{Compute win probability}
\usage{
calculate_win_probability(pbp_data)
}
\arguments{
\item{pbp_data}{Play-by-play dataset to estimate win probability for.}
}
\value{
The original pbp_data with the following columns appended to it:
\describe{
\item{wp}{win probability.}
\item{vegas_wp}{win probability taking into account pre-game spread.}
}
}
\description{
for provided plays. Returns the data with
probabilities of winning the game. The following columns
must be present: receive_h2_ko (1 if game is in 1st half and possession
team will receive 2nd half kickoff, 0 otherwise),
home_team, posteam, half_seconds_remaining, game_seconds_remaining,
spread_line (how many points home team was favored by), down, ydstogo,
yardline_100, posteam_timeouts_remaining, defteam_timeouts_remaining
}
\details{
Computes win probability for provided plays. Returns the data with
spread and non-spread-adjusted win probabilities. The following columns
must be present:
\itemize{
\item{receive_2h_ko (1 if game is in 1st half and possession team will receive 2nd half kickoff, 0 otherwise)}
\item{score_differential}
\item{home_team}
\item{posteam}
\item{half_seconds_remaining}
\item{game_seconds_remaining}
\item{spread_line (how many points home team was favored by)}
\item{down}
\item{ydstogo}
\item{yardline_100}
\item{posteam_timeouts_remaining}
\item{defteam_timeouts_remaining}
}
}
\examples{
\donttest{
try({# to avoid CRAN test problems
library(dplyr)
data <- tibble::tibble(
"receive_2h_ko" = 0,
"home_team" = "SEA",
"posteam" = "SEA",
"score_differential" = 0,
"half_seconds_remaining" = 1800,
"game_seconds_remaining" = 3600,
"spread_line" = c(1, 3, 4, 7, 14),
"down" = 1,
"ydstogo" = 10,
"yardline_100" = 75,
"posteam_timeouts_remaining" = 3,
"defteam_timeouts_remaining" = 3
)

nflfastR::calculate_win_probability(data) |>
  dplyr::select(spread_line, wp, vegas_wp)
})
}
}
