% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babble.r
\name{babble}
\alias{babble}
\alias{babble,ngram-method}
\title{ngram Babbler}
\usage{
babble(ng, genlen = 150, seed = getseed())

\S4method{babble}{ngram}(ng, genlen = 150, seed = getseed())
}
\arguments{
\item{ng}{An ngram object.}

\item{genlen}{Generated length, i.e., the number of words to babble.}

\item{seed}{Seed for the random number generator.}
}
\description{
The babbler uses its own internal PRNG (i.e., not R's), so seeds cannot be
managed as with R's seeds.  The generator is an implementation of MT19937.

At this time, we note that the seed may not guarantee the same results
across machines. Currently only Solaris produces different values from
mainstream platforms (Windows, Mac, Linux, FreeBSD), but potentially others
could as well.
}
\details{
A markov chain babbler.
}
\examples{
library(ngram)

str = "A B A C A B B"
ng = ngram(str)
babble(ng, genlen=5, seed=1234)

}
\seealso{
\code{\link{ngram}}, \code{\link{getseed}}
}
\keyword{Amusement}
