% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_par_rec.R
\name{bin_par_rec}
\alias{bin_par_rec}
\title{Maximum parsimony reconstruction of ancestral character states}
\usage{
bin_par_rec(tree_data, ...)
}
\arguments{
\item{tree_data}{a list of two elements (phy and data) resulting from using
the function \code{\link[geiger]{treedata}}.}

\item{...}{other arguments from \code{\link[castor]{asr_max_parsimony}}.
Arguments \code{tree} and \code{tip_states} are fixed.}
}
\value{
A table with columns representing bins, rows representing first tip
states and then reconstructed nodes.
}
\description{
Maximum parsimony reconstruction of ancestral character states
}
\details{
Reconstructions are done using the \code{\link[castor]{asr_max_parsimony}}
function from the \code{castor} package.
}
\examples{
# a simple tree
data("tree5", package = "nichevol")

# a matrix of niche charactes (1 = present, 0 = absent, ? = unknown)
dataTable <- cbind("241" = rep("1", length(tree5$tip.label)),
                   "242" = rep("1", length(tree5$tip.label)),
                   "243" = c("1", "1", "0", "0", "0"),
                   "244" = c("1", "1", "0", "0", "0"),
                   "245" = c("1", "?", "0", "0", "0"))
rownames(dataTable) <- tree5$tip.label

# list with two objects (tree and character table)
treeWdata <- geiger::treedata(tree5, dataTable)

# Maximum parsimony reconstruction
par_rec <- bin_par_rec(treeWdata)
}
