% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche_bars.R
\name{niche_bars}
\alias{niche_bars}
\title{PNG bar figures to represent ecological niches of distinct taxa}
\usage{
niche_bars(tree, whole_rec_table, present = "1", unknown = "?",
           present_col = "#e41a1c", unknown_col = "#969696",
           absent_col = "#377eb8", width = 50, height = 5, res = 300,
           output_directory, overwrite = FALSE)
}
\arguments{
\item{tree}{an object of class "phylo".}

\item{whole_rec_table}{matrix of environmental bins for all tips and nodes
derived from functions \code{\link{bin_par_rec}} or \code{\link{bin_ml_rec}}.}

\item{present}{(character) code indicating environmental bins in which the
species is present. Default = "1".}

\item{unknown}{(character) code indicating environmental bins in which the
species presence is unknown (uncertain). Default = "?".}

\item{present_col}{color for area of the bar representing environments where
the species is present. Default = "#e41a1c".}

\item{unknown_col}{color for area of the bar representing environments where
the species presence is unknown (uncertain). Default = "#969696".}

\item{absent_col}{color for area of the bar representing environments where
no change has been detected. Default = "#377eb8".}

\item{width}{(numeric) width of the device in mm to be passed to the
\code{\link[grDevices]{png}} function. Default = 50.}

\item{height}{(numeric) height of the device in mm to be passed to the
\code{\link[grDevices]{png}} function. Default = 5.}

\item{res}{(numeric) nominal resolution in ppi to be passed to the
\code{\link[grDevices]{png}} function. Default = 300.}

\item{output_directory}{(character) name of the folder in which results will
be written. The directory will be created as part of the process.}

\item{overwrite}{(logical) whether or not to overwrite existing results in
\code{output_directory}. Default = FALSE.}
}
\value{
A folder named as in \code{output_directory} containing all bar figures
produced, as well as a legend to describe what is plotted.
}
\description{
niche_bars produces bar plots that represent species
ecological niches in one environmental variable. Bars are exported as png
figures to an output directory for posterior use.
}
\details{
Ecological niches are represented in one environmental dimension with vertical
bars that indicate if the species is present, absent, or if its presence is
uncertain in the range of environmental conditions. Lower values of
environmental variables are represented in the left part of the bar, and the
opposite part of the bar represents higher values.
}
\examples{
# a simple tree
data("tree5", package = "nichevol")

# a matrix of niche charactes (1 = present, 0 = absent, ? = unknown)
dataTable <- cbind("241" = rep("1", length(tree5$tip.label)),
                   "242" = rep("1", length(tree5$tip.label)),
                   "243" = c("1", "1", "0", "0", "0"),
                   "244" = c("1", "1", "0", "0", "0"),
                   "245" = c("1", "?", "0", "0", "0"))
rownames(dataTable) <- tree5$tip.label

# list with two objects (tree and character table)
treeWdata <- geiger::treedata(tree5, dataTable)

# Maximum parsimony reconstruction
rec_tab <- smooth_rec(bin_par_rec(treeWdata))

# the running (before running, define a working directory)
niche_bars(tree5, rec_tab, output_directory = file.path(tempdir(), "nichebars"))
}
