% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_helpers.R
\name{niche_labels}
\alias{niche_labels}
\title{Labels to represent niches of tips and ancestors}
\usage{
niche_labels(tree, whole_rec_table, label_type = "tip_node",
             tip_offset = 0.015, present = "1", unknown = "?",
             present_col = "#e41a1c", unknown_col = "#969696",
             absent_col = "#377eb8", width = 1, height = 1)
}
\arguments{
\item{tree}{an object of class "phylo".}

\item{whole_rec_table}{matrix of environmental bins for all tips and nodes
derived from functions \code{\link{bin_par_rec}} or \code{\link{bin_ml_rec}}.}

\item{label_type}{(character) type of label; options are: "tip", "node", and
"tip_node". Default = "tip_node".}

\item{tip_offset}{(numeric) space between tips and the labels. Default = 0.015.}

\item{present}{(character) code indicating environmental bins in which the
species is present. Default = "1".}

\item{unknown}{(character) code indicating environmental bins in which the
species presence is unknown (uncertain). Default = "?".}

\item{present_col}{color for area of the bar representing environments where
the species is present. Default = "#e41a1c".}

\item{unknown_col}{color for area of the bar representing environments where
the species presence is unknown (uncertain). Default = "#969696".}

\item{absent_col}{color for area of the bar representing environments where
no change has been detected. Default = "#377eb8".}

\item{width}{value defining the width of niche bars; default = 1.}

\item{height}{value defining the height of niche bars; default = 1.}
}
\description{
niche_labels helps in adding bar-type labels that represent
species ecological niches in one environmental variable.
}
\details{
For the moment, only plots of type "phylogram" with "rightwards" or "leftwards"
directions, created with the function \code{\link[ape]{plot.phylo}} from the
package \code{ape} are supported.

Ecological niches are represented in one environmental dimension with vertical
bars that indicate if the species is present, absent, or if its presence is
uncertain in the range of environmental conditions. Lower values of
environmental variables are represented in the lower part of the bar, and the
opposite part of the bar represents higher values.
}
\examples{
# a simple tree
data("tree5", package = "nichevol")

# a matrix of niche charactes (1 = present, 0 = absent, ? = unknown)
dataTable <- cbind("241" = rep("1", length(tree5$tip.label)),
                   "242" = rep("1", length(tree5$tip.label)),
                   "243" = c("1", "1", "0", "0", "0"),
                   "244" = c("1", "1", "0", "0", "0"),
                   "245" = c("1", "?", "0", "0", "0"))
rownames(dataTable) <- tree5$tip.label

# list with two objects (tree and character table)
treeWdata <- geiger::treedata(tree5, dataTable)

# Maximum parsimony reconstruction
rec_tab <- smooth_rec(bin_par_rec(treeWdata))

# plotting and adding labels
ape::plot.phylo(tree5, label.offset = 0.04)
niche_labels(tree5, rec_tab, height = 0.6)
}
