% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_eval.R
\name{stats_eval}
\alias{stats_eval}
\title{Statistics of environmental conditions in M and for occurrences (one variable)}
\usage{
stats_eval(stats = c("median", "range"), Ms, occurrences, species,
           longitude, latitude, variable, percentage_out = 0, verbose = TRUE)
}
\arguments{
\item{stats}{(character) name or vector of names of functions to be applied
to get basic statistics of environmental values.}

\item{Ms}{a list of SpatVector objects representing the accessible area
(M) for each species to be analyzed. The order of species represented by each
object here must coincide with the one in \code{occurrences}. See details.}

\item{occurrences}{a list of data.frames of occurrence records for all species.
The order of species represented by each data.frame must coincide with the one
in \code{Ms}. See details.}

\item{species}{(character) name of the column in occurrence data.frames that
contains the name of the species.}

\item{longitude}{(character) name of the column in occurrence files containing
values of longitude.}

\item{latitude}{(character) name of the column in occurrence files containing
values of latitude.}

\item{variable}{a single SpatRaster layer of an environmental variable of
interest. See details.}

\item{percentage_out}{(numeric) percentage of extreme environmental data in M
to be excluded in bin creation for further analyses. See details. Default = 0.}

\item{verbose}{(logical) whether messages should be printed. Default = TRUE.}
}
\value{
A list containing tables with statistics of the values in \code{variable},
for the species M and occurrences.
}
\description{
stats_eval helps in creating tables of descriptive statistics
of environmental conditions in accessible areas (M) and occurrence
records for one environmental variable at a time.
}
\details{
Coordinates in \code{occurrences}, SpatVector objects in \code{Ms}, and
SpatRaster in \code{variable} must coincide in the geographic projection in
which they are represented. WGS84 with no planar projection is recommended.

Accessible area (M) is understood as the geographic area that has been
accessible for a species for relevant periods of time. Defining M is usually
a hard task, but also a very important one, because it allows identifying
uncertainties about the ability of a species to maintain populations in
certain environmental conditions. For further details on this topic, see
Barve et al. (2011) \url{doi:10.1016/j.ecolmodel.2011.02.011}
and Machado-Stredel et al. (2021) \url{doi:10.21425/F5FBG48814}.

The percentage to be defined in \code{percentage_out} excludes a percentage
of extreme environmental values to prevent from considering extremely rare
environmental values in the accessible area for the species (M). Being too
rare, these values may have never been explored by the species; therefore,
including them in the process of preparation of the table of characters
(bin table) is risky.
}
\examples{
# example data
## list of species records
data("occ_list", package = "nichevol")

## list of species accessible areas
m_files <- list.files(system.file("extdata", package = "nichevol"),
                      pattern = "m\\\\d.gpkg", full.names = TRUE)

m_list <- lapply(m_files, terra::vect)

## raster variable
temp <- terra::rast(system.file("extdata", "temp.tif", package = "nichevol"))

# running stats
stat <- stats_eval(stats = c("mean", "sd", "median", "range", "quantile"),
                   Ms = m_list, occurrences = occ_list, species = "species",
                   longitude = "x", latitude = "y", variable = temp,
                   percentage_out = 0)
}
