% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratRejectionSampler_exp.R
\name{stratRejectionSampler_exp}
\alias{stratRejectionSampler_exp}
\title{Stratified rejection sampler for multivariate exponential point process}
\usage{
stratRejectionSampler_exp(
  numPoints,
  lowerCoords,
  upperCoords,
  s,
  windowIntensities,
  lambda
)
}
\arguments{
\item{numPoints}{Number of spatial points to generate.}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of a set of detection windows. One row for each window.}

\item{s}{Vector of x- and y-coordinates of of the isotropic multivariate exponential distribution mean.}

\item{windowIntensities}{Vector of integrated intensities over all detection windows.}

\item{lambda}{Rate parameter of the isotropic multivariate exponential distribution.}
}
\value{
A matrix of x- and y-coordinates of the generated points. One row corresponds to one point.
}
\description{
Simulate data using a stratified rejection sampler from a point process with an isotropic multivariate exponential decay kernel.
}
\examples{
numPoints <- 10
lowerObsCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperObsCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
s <- c(1, 1)
windowIntensities <- c(1:4)
lambda <- 0.1
stratRejectionSampler_exp(numPoints, lowerObsCoords, upperObsCoords, s, windowIntensities, lambda)

}
\author{
Wei Zhang
}
