% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-functions_processing.R
\name{nmr_import_spectra}
\alias{nmr_import_spectra}
\title{Import and process NMR spectral data}
\usage{
nmr_import_spectra(path, method, pattern = "*.csv$", quiet = FALSE)
}
\arguments{
\item{path}{Directory where the spectra files are saved}

\item{method}{Software used for initial processing of NMR spectra (before using this package). Available options include "mnova" and "topspin".}

\item{pattern}{Filename pattern to search for (by default "*.csv$")}

\item{quiet}{Print diagnostic messages? Logical}
}
\value{
A \code{link{data.frame}} with data from all files found,
concatenated and sorted.
}
\description{
Imports multiple spectra files and then combines and cleans the data.
}
\examples{
sdir <- system.file("extdata", "kfp_hysteresis", "spectra_mnova", package = "nmrrr")
nmr_import_spectra(path = sdir, method = "mnova")
}
\author{
Kaizad Patel
}
