% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{cov.tct}
\alias{cov.tct}
\title{Covariance Matrix of the Entries of the Type I-IV TCTs}
\usage{
cov.tct(ct, covN, type = "III")
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized cell counts of NNCT, \code{ct}.}

\item{type}{The type of the cell-specific test, default=\code{"III"}. Takes on values \code{"I"}-\code{"IV"} (or 
equivalently \code{1-4}, respectively.}
}
\value{
The \eqn{k^2 \times k^2} covariance matrix of
the entries \eqn{T_{ij}} for \eqn{i,j=1,\ldots,k} in the Type I-IV TCTs
}
\description{
Returns the covariance matrix of the entries \eqn{T_{ij}} 
for \eqn{i,j=1,\ldots,k} in the TCT for the types I, III, 
and IV cell-specific tests. 
The covariance matrix is of dimension \eqn{k^2 \times k^2} 
and its entries are \eqn{cov(T_{ij},T_{kl})}
when \eqn{T_{ij}} values are by default corresponding 
to the row-wise vectorization of TCT. 
The argument \code{covN} must be the covariance matrix of 
\eqn{N_{ij}} values which are obtained from the NNCT by row-wise
vectorization.
The functions \code{cov.tctIII} and \code{cov.tct3} are equivalent.
These covariances are valid under RL 
or conditional on \eqn{Q} and \eqn{R} under CSR.

See also (\insertCite{ceyhan:jkss-posthoc-2017;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

cov.tct(ct,covN,type=1)
cov.tct(ct,covN,type="I")
cov.tct(ct,covN,type="II")
cov.tct(ct,covN,type="III")
cov.tct(ct,covN,type="IV")
cov.tctI(ct,covN)

cov.tct(ct,covN)
cov.tctIII(ct,covN)
cov.tct3(ct,covN)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)

covN<-cov.nnct(ct,varN,Qv,Rv)

cov.tct(ct,covN,type=3)
cov.tct(ct,covN,type="III")

cov.tctIII(ct,covN)
cov.tct3(ct,covN)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cov.nnct}} and \code{\link{cov.nnsym}}
}
\author{
Elvan Ceyhan
}
