% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZnnref}
\alias{funsZnnref}
\alias{Znnref.ct}
\alias{Znnref}
\title{Z Tests for NN Reflexivity}
\usage{
Znnref.ct(
  rfct,
  nvec,
  Qv,
  Tv,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Znnref(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{rfct}{An RCT, used in \code{Znnref.ct} only}

\item{nvec}{The \code{vector} of class sizes, used in \code{Znnref.ct} only}

\item{Qv}{The number of shared NNs, used in \code{Znnref.ct} only}

\item{Tv}{\eqn{T} value, which is the number of triplets \eqn{(z_i, z_j, z_k)} with 
"\eqn{NN(z_i) = NN(z_j) = z_k} and \eqn{NN(z_k) = z_j} where \eqn{NN(\cdot)} is the nearest neighbor function, used in \code{Znnref.ct} only.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the difference of the off-diagonal entries, \eqn{N_{12}-N_{21}}}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Znnref} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Znnref} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function, used in \code{Znnref} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistics for self reflexivity and mixed non-reflexivity, corresponding to entries
\eqn{(1,1)} and \eqn{(2,2)} in the RCT}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \eqn{p}-values for self reflexivity and mixed non-reflexivity tests}
\item{conf.int}{Confidence intervals for the self reflexivity and mixed non-reflexivity values
(i.e., diagonal entries \eqn{(1,1)} and \eqn{(2,2)} values, respectively) in the RCT at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{cnf.lvl}{Level of the onfidence intervals of the diagonal entries, provided in \code{conf.level}.}
\item{estimate}{Estimates of the parameters, i.e., the observed diagonal entries \eqn{(1,1)} and \eqn{(2,2)}
in the RCT, \code{rfct}.}
\item{null.value}{Hypothesized null values for the self reflexivity and mixed non-reflexivity values
(i.e., expected values of the diagonal entries \eqn{(1,1)} and \eqn{(2,2)} values, 
which are \eqn{E(N_{11})=R P_{aa}} and \eqn{E(N_{22})=R P_{ab}}, respectively) in the RCT.}
\item{null.name}{Name of the null values}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{rfct}, returned by \code{Znnref.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Znnref} only}
}
\description{
Two functions: \code{Znnref.ct} and \code{Znnref}.

Both functions are objects of class \code{"refhtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of equality of the expected values of the
diagonal cell counts (i.e., entries) under RL or CSR in the RCT for \eqn{k \ge 2} classes.
That is, each test performs NN reflexivity test (i.e., a test of self reflexivity and a test of
mixed non-reflexivity, corresponding to entries \eqn{(1,1)} and \eqn{(2,2)}, respectively, in the RCT) which is
appropriate (i.e., have the appropriate asymptotic sampling distribution) for completely mapped data.
(See \insertCite{ceyhan:NNreflexivity2017;textual}{nnspat} for more detail).

The reflexivity test is based on the normal approximation of the diagonal entries
in the RCT and are due to \insertCite{ceyhan:NNreflexivity2017;textual}{nnspat}.

Each function yields the test statistics, \eqn{p}-values for the corresponding 
alternative, expected values (i.e., null value(s)), confidence intervals and sample estimates (i.e., observed values)for the
self reflexivity and mixed non-reflexivity values (i.e., entries \eqn{(1,1)} and \eqn{(2,2)} values, respectively)
in the RCT. Each function also gives names of the test statistics, null values, the description of the test, and the data
set used.

The null hypothesis is that \eqn{E(N_{11})=R P_{aa}} and \eqn{E(N_{22})=R P_{ab}} in the RCT, where \eqn{R} is the number of reflexive
NNs and \eqn{P_{aa}} is the probability of any two points selected are being from the same class
and \eqn{P_{ab}} is the probability of any two points selected are being from two different classes.

The \code{Znnref} functions (i.e., \code{Znnref.ct} and \code{Znnref}) are different from 
the \code{Znnself} functions (i.e., \code{\link{Znnself.ct}} and \code{\link{Znnself}}) and 
from \code{Zself.ref} functions (i.e., \code{\link{Zself.ref.ct}} and \code{\link{Zself.ref}}), and also
from \code{Znnself.sum} functions (i.e., \code{Znnself.sum.ct} and \code{Znnself.sum}).
\code{Znnref} functions are for testing the self reflexivity and mixed non-reflexivity
using the diagonal entries in the RCT while \code{Znnself} functions are testing the self reflexivity at a
class-specific level (i.e., for each class) using the first column in the SCCT, and
\code{Zself.ref} functions are for testing the self reflexivity for the entire data set
using entry \eqn{(1,1)} in RCT, and \code{Znnself.sum} functions are testing the cumulative species correspondence using
the sum of the self column (i.e., the first column) in the SCCT.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
Tv<-Tval(W,Rv)

nvec<-as.numeric(table(cls))
rfct<-rct(ipd,cls)

Znnref(Y,cls)
Znnref(Y,cls,method="max")

Znnref.ct(rfct,nvec,Qv,Tv)
Znnref.ct(rfct,nvec,Qv,Tv,alt="g")

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Qv<-Qvec(W)$q
R<-Rval(W)
Tv<-Tval(W,R)

nvec<-as.numeric(table(cls))
rfct<-rct(ipd,cls)

Znnref(Y,cls,alt="g")

Znnref.ct(rfct,nvec,Qv,Tv)
Znnref.ct(rfct,nvec,Qv,Tv,alt="l")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnself.ct}}, \code{\link{Znnself}}, \code{\link{Zmixed.nonref.ct}},
\code{\link{Zmixed.nonref}}, \code{\link{Xsq.nnref.ct}} and \code{\link{Xsq.nnref}}
}
\author{
Elvan Ceyhan
}
