% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rnonRLI}
\alias{rnonRLI}
\title{Type I Non-Random Labeling of a Given Set of Points}
\usage{
rnonRLI(dat, prop = 0.5, k, rho, poisson = FALSE, init.from.cases = TRUE)
}
\arguments{
\item{dat}{A set of points the non-RL procedure is applied to obtain cases and controls randomly in the 
type I fashion (see the description).}

\item{prop}{A real number between 0 and 1 (inclusive) representing the proportion of new cases (on the average)
infected by the initial cases, i.e., number of newly infected cases (in addition to the initial cases) is
Poisson with \code{mean=round(n*prop)} where \eqn{n} is the number of points in \code{dat}, if the argument \code{poisson=TRUE},
else it is \code{round(n*prop)}.}

\item{k}{An integer representing the number of NNs considered for each initial case, i.e., \code{k}NNs of each
initial case are candidates to be infected to become cases.}

\item{rho}{A parameter for labeling the \code{k}NNs of each initial case as cases such that \code{k}NNs of each initial case
is infected with decreasing probabilities \code{prob=c(prop+((1-prop)*rho)/(1:k))} where
\code{rho} has to be between \code{-prop/(1-prop)} and 1 for \code{prob} to be a \code{vector} of probabilities.}

\item{poisson}{A logical argument (default is \code{FALSE}) to determine whether the number of cases \eqn{n_1},
will be random or fixed. If \code{poisson=TRUE} then the \eqn{n_1} is from a Poisson distribution, 
\eqn{n_1=}\code{rpois(1,round(n*prop,0))} 
otherwise it is fixed, \eqn{n_1=}\code{round(n*prop,0)}.}

\item{init.from.cases}{A logical argument (default is \code{TRUE}) to determine whether the initial cases at each
round will be take from cases or controls. At first round, the initial cases are taken from controls.
And in the subsequent rounds, the initial cases are taken from cases if \code{init.from.cases=TRUE},
and from controls otherwise.}
}
\value{
A \code{list} with the elements 
\item{pat.type}{\code{="cc"} for the case-control patterns for RL or non-RL of the given data points, \code{dat}}
\item{type}{The type of the point pattern}
\item{parameters}{\code{prop}, \code{rho}, and \code{k} values for this non-RL pattern, see the description for these
parameters.}
\item{dat.points}{The set of points non-RL procedure is applied to obtain cases and controls randomly in the 
type I fashion}
\item{lab}{The labels of the points as 1 for cases and 0 for controls after the type I nonRL procedure is
applied to the data set, \code{dat}. Cases are denoted as red dots and controls as black circles in the plot.}
\item{init.cases}{The initial cases in the data set, \code{dat}. Marked with red crosses in the plot of the points.}
\item{gen.points,ref.points}{Both are \code{NULL} for this function, as initial set of points, \code{dat}, are provided
for the non-RL procedure.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of cases and controls.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and the reference points}
}
\description{
An object of class \code{"SpatPatterns"}.

Given the set of \eqn{n} points, \code{dat}, in a region, this function assigns \eqn{n_1=}\code{round(n*prop,0)} of them as cases,
and the rest as controls with first selecting a point, \eqn{Z_i}, as a case and assigning the
label case to the remaining points with infection probabilities 
\code{prob=c(prop+((1-prop)*rho)/(1:k))} where \code{rho} is a
parameter adjusting the NN dependence of infection probabilities.
The number of cases will be \eqn{n_1} on the average if the argument \code{poisson=TRUE}
(i.e., \eqn{n_1=}\code{rpois(1,round(n*prop,0))}), otherwise \eqn{n_1=}\code{round(n*prop,0)}.
We stop when we first exceed \eqn{n_1} cases. \code{rho} must be between \code{-prop/(1-prop)} and 1 for the infection
probabilities to be valid.
The \code{init.from.cases} is a logical argument (with default=\code{TRUE}) to determine the initial cases are from the
cases or controls (the first initial case is always from controls), so, if \code{TRUE}, initial cases (other than
the first initial case) are selected randomly among the cases (as if they are contagious), otherwise,
they are selected from controls as new cases infecting their \code{k}NNs.
otherwise first entry is chosen as the case (or case is recorded as the first entry) in the data set, \code{dat}.  

Algorithmically, first all dat points are treated as non-cases (i.e., controls or healthy subjects).
Then the function follows the following steps for labeling of the points:  

step 0: \eqn{n_1} is generated randomly from a Poisson distribution with \code{mean = n*prop}, so that the 
average number of cases is \code{n*prop}. 

step 0: \eqn{n_1} is generated randomly from a Poisson distribution with \code{mean = round(n*prop,0)}, so that the 
average number of cases will be \code{round(n*prop,0)}
if the argument \code{poisson=TRUE}, else \eqn{n_1=}\code{round(n*prop,0)}.

step 1: Initially, one point from dat is selected randomly as a case. In the first round this point is selected
from the controls, and the subsequent rounds, it is selected from cases if the argument \code{init.from.cases=TRUE},
and from controls otherwise. Then it assigns the label case to the \code{k}NNs among controls of the initial case
selected in step 1 with infection probabilities \code{prob=c(prop+((1-prop)*rho)/(1:k))}, see the description for the details
of the parameters in the \code{prob}.
 
step 2: Then this initial case and cases among its \code{k}NNs (possibly all \eqn{k+1} points) in step 2 are removed from
the data, and for the remaining control points step 1 is applied where initial point is from cases or control
based on the argument init.from.cases.

step 3: The procedure ends when number of cases \eqn{n_c} exceeds \eqn{n_1}, and \eqn{n_c-n_1} of the cases (other than the
initial cases) are randomly selected and relabeled as controls, i.e., 0s,
so that the number of cases is exactly \eqn{n_1}.

In the output cases are labeled as 1 and controls as 0.
Note that the infection probabilities of the \code{k}NNs of each initial case increase
with increasing rho, and infection probability decreases for increasing k in the \code{k}NNs. 
 
See \insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat} for more detail where type I non-RL pattern is the 
case 1 of non-RL pattern considered in Section 6 with \eqn{n_1} is
fixed as a parameter rather than being generated from a Poisson distribution and \code{init=FALSE}.

Although the non-RL pattern is described for the case-control setting, it can be adapted for any two-class
setting when it is appropriate to treat one of the classes as cases or one of the classes behave like cases
and other class as controls.
}
\examples{
n<-40;  #try also n<-20; n<-100;
#data generation
dat<-cbind(runif(n,0,1),runif(n,0,1))

prop<-.5; #try also .25, .75
rho<- .3
knn<-3 #try 2 or 5

Xdat<-rnonRLI(dat,prop,knn,rho,poisson=FALSE,init=FALSE) 
#labeled data try also poisson=TRUE or init=FALSE
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#normal original data
n<-40;  #try also n<-20; n<-100;
#data generation
dat<-cbind(rnorm(n,0,1),rnorm(n,0,1))

prop<-.50; #try also .25, .75
rho<- .3
knn<-5 #try 2 or 3

Xdat<-rnonRLI(dat,prop,knn,rho,poisson=FALSE) #labeled data try also poisson=TRUE
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rnonRLII}}, \code{\link{rnonRLIII}}, \code{\link{rnonRLIV}}, and \code{\link{rnonRL}}
}
\author{
Elvan Ceyhan
}
