% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000_common.R
\name{findnoise}
\alias{findnoise}
\title{Find the differences between two datasets}
\usage{
findnoise(x, y, xnoise, ynoise, model)
}
\arguments{
\item{x}{a data frame of input attributes (clean dataset).}

\item{y}{a factor vector with the output class of each sample (clean dataset).}

\item{xnoise}{a data frame of input attributes (noisy dataset).}

\item{ynoise}{a factor vector with the output class of each sample (noisy dataset).}

\item{model}{a character with the name of the noise model.}
}
\value{
A list with four elements:
\item{numnoise}{an integer vector with the amount of noisy samples per variable.}
\item{idnoise}{an integer vector list with the indices of noisy samples per variable.}
\item{numclean}{an integer vector with the amount of clean samples per variable.}
\item{idclean}{an integer vector list with the indices of clean samples per variable.}
}
\description{
Detect the differences between two datasets, focusing on the input attributes (\code{x}, 
\code{xnoise}), the output class (\code{y}, \code{ynoise}) or both depending on the type of 
the model (label, attributes, combined).
}
\keyword{internal}
