% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/013_hubp_uni_ln.R
\name{hubp_uni_ln}
\alias{hubp_uni_ln}
\alias{hubp_uni_ln.default}
\alias{hubp_uni_ln.formula}
\title{Hubness-proportional uniform label noise}
\usage{
\method{hubp_uni_ln}{default}(x, y, level, k = 3, sortid = TRUE, ...)

\method{hubp_uni_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{k}{an integer with the number of neighbors to compute the hubness of each sample (default: 3).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Hubness-proportional uniform label noise} into a classification dataset.
}
\details{
\emph{Hubness-proportional uniform label noise} is based on the presence of hubs
in the dataset. It selects (\code{level}·100)\% of the samples in the dataset using a 
discrete probability distribution based on the concept of hubness, which is computed 
using the nearest neighbors of each sample. Then, the class labels
of these samples are randomly replaced by different ones from the \emph{c} classes.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- hubp_uni_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- hubp_uni_ln(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
N. Tomasev and K. Buza. 
\strong{Hubness-aware kNN classification of high-dimensional data in presence of label noise}. 
\emph{Neurocomputing}, 160:157-172, 2015. 
\doi{10.1016/j.neucom.2014.10.084}.
}
\seealso{
\code{\link{smu_cuni_ln}}, \code{\link{oned_uni_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
