% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/018_mind_bdir_ln.R
\name{mind_bdir_ln}
\alias{mind_bdir_ln}
\alias{mind_bdir_ln.default}
\alias{mind_bdir_ln.formula}
\title{Minority-driven bidirectional label noise}
\usage{
\method{mind_bdir_ln}{default}(x, y, level, pos = 0.1, sortid = TRUE, ...)

\method{mind_bdir_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{pos}{a double in [0,1] with the proportion of samples from the positive class (default: 0.1).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Minority-driven bidirectional label noise} into a classification dataset.
}
\details{
\emph{Minority-driven bidirectional label noise} randomly selects \emph{n} = 2\emph{m}·\code{level} samples
in the dataset (with \emph{m} the number of samples in the minority class), making sure that \emph{n}·\code{pos} samples 
belong to the minority class and the rest to the majority class. 
Then, minority class samples are mislabeled as belonging to the majority class and majority class 
samples are mislabeled as belonging to the minority class. In case of ties determining minority and majority classes, 
a random class is chosen among them.
}
\note{
Noise model adapted from the papers in References to multiclass data.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- mind_bdir_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.5)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- mind_bdir_ln(formula = Species ~ ., data = iris2D, level = 0.5)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
A. Folleco, T. M. Khoshgoftaar, J. V. Hulse, and L. A. Bullard. 
\strong{Software quality modeling: The impact of class noise on the random forest classifier}. 
In \emph{Proc. 2008 IEEE Congress on Evolutionary Computation}, pages 3853–3859, 2008.
\doi{10.1109/CEC.2008.4631321}.
}
\seealso{
\code{\link{fra_bdir_ln}}, \code{\link{irs_bdir_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
