% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/053_ugau_bor_ln.R
\name{ugau_bor_ln}
\alias{ugau_bor_ln}
\alias{ugau_bor_ln.default}
\alias{ugau_bor_ln.formula}
\title{Uneven-Gaussian borderline label noise}
\usage{
\method{ugau_bor_ln}{default}(
  x,
  y,
  level,
  mean = 0,
  sd = 1,
  k = 1,
  order = levels(y),
  sortid = TRUE,
  ...
)

\method{ugau_bor_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double vector with the noise levels in [0,1] to be introduced into each class.}

\item{mean}{a double with the mean for the Gaussian distribution (default: 0).}

\item{sd}{a double with the standard deviation for the Gaussian distribution (default: 1).}

\item{k}{an integer with the number of nearest neighbors to be used (default: 1).}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Uneven-Gaussian borderline label noise} into a classification dataset.
}
\details{
\emph{Uneven-Gaussian borderline label noise} uses an SVM to induce the decision border 
in the dataset. For each sample, its distance
to the decision border is computed. Then, a Gaussian distribution with parameters (\code{mean}, \code{sd}) is 
used to compute the value for the probability density function associated to each distance. 
For each class \emph{c}[i], it randomly selects (\code{level}[i]·100)\% of the samples
in the dataset based on their values of the probability density function -the order of the class labels is determined by
\code{order}. For each noisy sample, the 
majority class among its \code{k}-nearest neighbors of a different class 
is chosen as the new label.
}
\note{
Noise model adapted from the papers in References to multiclass data, considering SVM with linear 
kernel as classifier, a mislabeling process using the neighborhood of noisy samples and a 
noise level to control the number of errors in the data.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- ugau_bor_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                      level = c(0.1, 0.2, 0.3), order = c("virginica", "setosa", "versicolor"))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- ugau_bor_ln(formula = Species ~ ., data = iris2D,
                      level = c(0.1, 0.2, 0.3), order = c("virginica", "setosa", "versicolor"))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
J. Du and Z. Cai. 
\strong{Modelling class noise with symmetric and asymmetric distributions}. 
In \emph{Proc. 29th AAAI Conference on Artificial Intelligence}, pages 2589-2595, 2015.
url:\url{https://dl.acm.org/doi/10.5555/2886521.2886681}.
}
\seealso{
\code{\link{gaum_bor_ln}}, \code{\link{gau_bor_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
