% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_selection.R
\name{control_sel}
\alias{control_sel}
\title{Control Parameters for the Selection Model}
\usage{
control_sel(
  est_method = c("mle", "gee"),
  gee_h_fun = 1,
  optimizer = c("maxLik", "optim"),
  maxlik_method = c("NR", "BFGS", "NM"),
  optim_method = c("BFGS", "Nelder-Mead"),
  epsilon = 1e-04,
  maxit = 500,
  trace = FALSE,
  penalty = c("SCAD", "lasso", "MCP"),
  a_SCAD = 3.7,
  a_MCP = 3,
  lambda = -1,
  lambda_min = 0.001,
  nlambda = 50,
  nfolds = 10,
  print_level = 0,
  start_type = c("zero", "mle", "naive"),
  nleqslv_method = c("Broyden", "Newton"),
  nleqslv_global = c("dbldog", "pwldog", "cline", "qline", "gline", "hook", "none"),
  nleqslv_xscalm = c("fixed", "auto"),
  dependence = FALSE,
  key = NULL
)
}
\arguments{
\item{est_method}{Method of estimation for propensity score model (\code{"mle"} or \code{"gee"}; default is \code{"mle"}).}

\item{gee_h_fun}{Smooth function for the generalized estimating equations (GEE) method.}

\item{optimizer}{(for the \code{est_method="mle"} only) optimization function for maximum likelihood estimation.}

\item{maxlik_method}{(for the \code{est_method="mle"} only) maximisation method that will be passed to \code{\link[maxLik:maxLik]{maxLik::maxLik()}} function. Default is \code{NR}.}

\item{optim_method}{(for the \code{est_method="mle"} only) maximisation method that will be passed to \code{\link[stats:optim]{stats::optim()}} function. Default is \code{BFGS}.}

\item{epsilon}{Tolerance for fitting algorithms by default \code{1e-6}.}

\item{maxit}{Maximum number of iterations.}

\item{trace}{logical value. If \code{TRUE} trace steps of the fitting algorithms. Default is \code{FALSE}}

\item{penalty}{The penalization function used during variables selection.}

\item{a_SCAD}{The tuning parameter of the SCAD penalty for selection model. Default is 3.7.}

\item{a_MCP}{The tuning parameter of the MCP penalty for selection model. Default is 3.}

\item{lambda}{A user-specified \eqn{\lambda} value during variable selection model fitting.}

\item{lambda_min}{The smallest value for lambda, as a fraction of \code{lambda.max}. Default is .001.}

\item{nlambda}{The number of \code{lambda} values. Default is 50.}

\item{nfolds}{The number of folds for cross validation. Default is 10.}

\item{print_level}{this argument determines the level of printing which is done during the optimization (for propensity score model) process.}

\item{start_type}{\itemize{
\item Type of method for start points for model fitting taking the following values
\itemize{
\item if \code{zero} then start is a vector of zeros (default for all methods).
\item if \code{mle} (for \code{est_method="gee"} only) starting parameters are taken from the result of the \code{est_method="mle"} method.
}
}}

\item{nleqslv_method}{(for the \code{est_method="gee"} only) The method that will be passed to \code{\link[nleqslv:nleqslv]{nleqslv::nleqslv()}} function.}

\item{nleqslv_global}{(for the \code{est_method="gee"} only) The global strategy that will be passed to \code{\link[nleqslv:nleqslv]{nleqslv::nleqslv()}} function.}

\item{nleqslv_xscalm}{(for the \code{est_method="gee"} only) The type of x scaling that will be passed to \code{\link[nleqslv:nleqslv]{nleqslv::nleqslv()}} function.}

\item{dependence}{logical value (default \code{TRUE}) informing whether samples overlap (NOT YET IMPLEMENTED, FOR FUTURE DEVELOPMENT).}

\item{key}{binary key variable allowing to identify the overlap (NOT YET IMPLEMENTED, FOR FUTURE DEVELOPMENT).}
}
\value{
List with selected parameters.
}
\description{
\code{control_sel} constructs a list with all necessary control parameters
for selection model.
}
\details{
Smooth function (\code{gee_h_fun}) for the generalized estimating equations (GEE) method taking the following values

\itemize{
\item{if \code{1} then \eqn{\boldsymbol{h}\left(\boldsymbol{x}, \boldsymbol{\theta}\right) =
  \frac{\pi(\boldsymbol{x}, \boldsymbol{\theta})}{\boldsymbol{x}}},}
\item{if \code{2} then \eqn{ \boldsymbol{h}\left(\boldsymbol{x}, \boldsymbol{\theta}\right) = \boldsymbol{x}}}
}
}
\seealso{
\code{\link[=nonprob]{nonprob()}} -- for fitting procedure with non-probability samples.
}
