% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparboot.R
\name{nonparboot}
\alias{nonparboot}
\title{Nonparametric Bootstrap Test with Pooled Resampling for Small Sample Sizes}
\usage{
nonparboot(
  data,
  x,
  y = NULL,
  grp = NULL,
  nboot,
  test = c("t", "pt", "F"),
  conf.level = 0.95,
  seed = NULL,
  na_rm = FALSE
)
}
\arguments{
\item{data}{A data frame containing the variables to be analyzed.}

\item{x}{A character string specifying the column in 'data' to be used as the
primary variable.}

\item{y}{An optional character string specifying the column in 'data' to be
used as the second variable for paired t-tests. Default is NULL.}

\item{grp}{An optional character string specifying the column in 'data' to be
used as the grouping variable for independent t-tests and F-tests. Default
is NULL.}

\item{nboot}{An integer specifying the number of bootstrap resamples to
perform.}

\item{test}{A character string specifying the type of test to perform. Must
be one of "t", "pt", or "F" for independent t-test, paired t-test, or F-test,
respectively. Default is "t".}

\item{conf.level}{A numeric value between 0 and 1 specifying the confidence
level for confidence intervals. Default is 0.95.}

\item{seed}{An optional value interpreted as an integer to set the seed for
the random number generator, for reproducibility. Default is NULL (no seed).}

\item{na_rm}{Remove observations with missing values. Default is FALSE.}
}
\value{
A list with the following components:
\itemize{
\item \code{p.value}: The p-value of the test.
\item \code{orig.stat}: The test statistic calculated from the original data.
\item \code{ci.stat}: The confidence interval for the test statistic from the bootstrap distribution.
\item \code{bootstrap.stat.dist}: The distribution of the test statistic values from the bootstrap resamples.
\item \code{effect.size}: The effect size (mean difference or eta-squared) calculated from the original data.
\item \code{ci.effect.size}: The confidence interval for the effect size from the bootstrap distribution.
\item \code{bootstrap.effect.dist}: The distribution of effect size values from the bootstrap resamples.
}
}
\description{
This function performs a nonparametric bootstrap test with pooled resampling
for small sample sizes, as described in Dwivedi et al. (2017). It supports
t-tests (independent and paired) and F-tests (one-way ANOVA), with a
user-specified number of bootstrap resamples.
}
\examples{
# Example usage of nonparboot
np_res <- nonparboot(iris, x = "Sepal.Length", grp = "Species", nboot = 1000, test = "F")
print(np_res$p.value)
}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA (2017). "Analysis of small sample size
studies using nonparametric bootstrap test with pooled resampling method." Statistics
in Medicine, 36 (14), 2187-2205. https://doi.org/10.1002/sim.7263
}
