% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_ts2.R
\name{replext_ts2_c1.2}
\alias{replext_ts2_c1.2}
\title{Replicate and Extend Type I Error Rates for ANOVA in a Different Setting}
\usage{
replext_ts2_c1.2(
  M1 = 5,
  S1 = 1,
  M2 = 5,
  S2 = 2,
  M3 = 5,
  S3 = 4,
  Sk1 = NULL,
  Sk2 = NULL,
  Sk3 = NULL,
  n1 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 15),
  n2 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 15),
  n3 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 15),
  n_simulations = 10000,
  nboot = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{M1}{Mean for the first group, default is 5.}

\item{S1}{Standard deviation for the first group, default is 1.}

\item{M2}{Mean for the second group, default is 5.}

\item{S2}{Standard deviation for the second group, default is 2.}

\item{M3}{Mean for the third group, default is 5.}

\item{S3}{Standard deviation for the third group, default is 4.}

\item{Sk1}{Skewness parameter for the first group, NULL implies normal distribution.}

\item{Sk2}{Skewness parameter for the second group, NULL implies normal distribution.}

\item{Sk3}{Skewness parameter for the third group, NULL implies normal distribution.}

\item{n1}{Vector of sample sizes for the first group.}

\item{n2}{Vector of sample sizes for the second group.}

\item{n3}{Vector of sample sizes for the third group, must be the same length as n1 and n2.}

\item{n_simulations}{Number of simulations to run, default is 10,000.}

\item{nboot}{Number of bootstrap samples for the nonparametric bootstrap test, default is 1000.}

\item{conf.level}{Confidence level for calculating p-value thresholds, default is 0.95.}
}
\value{
A data frame similar to \code{replext_ts2_c1.1} with columns for each sample size combination
(n1, n2, n3) and the proportions of significant p-values for each test (ANOVA,
Kruskal-Wallis, Nonparametric Bootstrap F-test, Permutation F-test), but with the modified
default parameters.
}
\description{
This wrapper function is designed to reproduce or extend the Type I error rate analysis for
ANOVA (Analysis of Variance) in a different setting as compared to \code{replext_ts2_c1.1}. It utilizes
different default values for the standard deviations of the second and third groups, allowing
for a different simulation setup. It is part of the analysis extending the supplemental tables
of the paper by Dwivedi et al. (2017).
}
\examples{
replext_ts2_c1.2(n1 = c(10), n2 = c(10), n3 = c(10), n_simulations = 1)

}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA. Analysis of small sample size
studies using nonparametric bootstrap test with pooled resampling method.
Stat Med. 2017 Jun 30;36(14):2187-2205. doi: 10.1002/sim.7263. Epub 2017 Mar 9. PMID: 28276584.
}
\seealso{
\code{\link{replext_ts2_c1.1}}
}
