% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpu.time.R
\name{cpu.time}
\alias{cpu.time}
\title{Total and partial CPU time used}
\usage{
cpu.time(..., reset = FALSE, total = TRUE, last = TRUE, flush = FALSE)
}
\arguments{
\item{...}{objects (describing the last operation) to be printed (using \code{\link{cat}}), 
if \code{last == TRUE}.}

\item{reset}{logical; if \code{TRUE}, time counters are initialized.}

\item{total}{logical; if \code{TRUE}, the total time used is printed.}

\item{last}{logical; if \code{TRUE}, the partial time used is printed.}

\item{flush}{logical; if \code{TRUE}, \code{\link{flush.console}} is called.}
}
\value{
Invisibly returns a list with  the following 3 components 
(objects of class \code{"proc_time"}):
\item{time}{user, system, and total elapsed times for the currently running R process 
(result of a call to \code{\link{proc.time}}). }
\item{last, total}{differences between the corresponding \code{\link{proc.time}} calls.}
}
\description{
Returns and (optionally) prints the total and/or partial (since the last call to this function) 
real and CPU times.
}
\examples{
cpu.time(reset=TRUE)
res <- median(runif(100000))
cpu.time('\nSample median of', 100000, 'values =', res)
res <- median(runif(1000))
cpu.time('\nSample median of', 1000, 'values =', res)
}
\seealso{
\code{\link{proc.time}}, \code{\link{system.time}}, \code{\link{flush.console}}.
}
