% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nspmix-package.R
\docType{data}
\name{betablockers}
\alias{betablockers}
\title{Beta-blockers Data}
\format{
A numeric matrix with four columns:

center: center identification code.

deaths: the number of deaths in the center.

total: the number of patients taking beta-blockers in the center.

treatment: 0 for control, and 1 for treatment.
}
\source{
Aitkin, M. (1999). A general maximum likelihood analysis of variance
components in generalized linear models. \emph{Biometrics}, \bold{55},
117-128.
}
\description{
Contains the data of the 22-center clinical trial of beta-blockers for
reducing mortality after myocardial infarction.
}
\examples{


data(betablockers)
x = mlogit(betablockers)
cnmms(x)


}
\references{
Wang, Y. (2010). Maximum likelihood computation for fitting semiparametric
mixture models. \emph{Statistics and Computing}, \bold{20}, 75-86.
}
\seealso{
\code{\link{mlogit}},\code{\link{cnmms}}.
}
