% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npgeom.R
\name{npgeom}
\alias{npgeom}
\alias{rnpgeom}
\alias{dnpgeom}
\alias{pnpgeom}
\title{Class \code{npgeom}}
\usage{
npgeom(v, w=1, grouping=FALSE)
rnpgeom(n, mix=disc(0.5))
dnpgeom(x, mix=disc(0.5), log=FALSE)
pnpgeom(x, mix=disc(0.5), lower.tail=TRUE, log.p=FALSE)
}
\arguments{
\item{v}{a numeric vector that stores the values of a sample.}

\item{w}{a numeric vector that stores the corresponding
weights/frequencies of the observations.}

\item{grouping}{logical, whether or not use frequencies (w) for
identical values.}

\item{n}{the sample size.}

\item{x}{an object of class \code{npgeom}.}

\item{mix}{an object of class \code{disc}.}

\item{log, }{=FALSE, if log-values are to be returned.}

\item{lower.tail, }{=FALSE, if lower.tail values are to be
returned.}

\item{log.p, }{=FALSE, if log probability values are to be
returned.}
}
\description{
Class \code{npgeom} is used to store data that will be
   processed as those of a nonparametric geometric mixture.

Function \code{npgeom} creates an object of class \code{npgeom},
given values and weights/frequencies.

Function \code{rnpgeom} generates a random sample from a geometric
mixture and saves the data as an object of class \code{npgeom}.

Function \code{dnpgeom} is the density function of a Poisson
mixture.

Function \code{pnpgeom} is the distribution function of a Poisson
mixture.
}
\examples{

mix = disc(pt=c(0.2,0.5), pr=c(0.3,0.7))
(x = rnpgeom(200, mix))
dnpgeom(x, mix)
pnpgeom(x, mix)

}
\references{
Wang, Y. (2007). On fast computation of the non-parametric maximum
likelihood estimate of a mixing distribution. \emph{Journal of the
Royal Statistical Society, Ser. B}, \bold{69}, 185-198.
}
\seealso{
\code{\link[lsei]{nnls}}, \code{\link{cnm}},
  \code{\link{cnmms}}, \code{\link{plot.nspmix}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
