% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantize_commsim.R
\name{quantize_commsim}
\alias{quantize_commsim}
\title{Quantize-based commsim (non-sequential)}
\usage{
quantize_commsim(n_iter = 10000, ...)
}
\arguments{
\item{n_iter}{Integer, number of iterations (trades) per simulated
matrix. Must be a positive integer. Default is \code{1e4}.}

\item{...}{Arguments passed to \code{\link[=quantize]{quantize()}},
such as \code{breaks}, \code{n_strata}, \code{transform}, \code{offset},
\code{zero_stratum}, \code{fixed}, \code{method}, etc. Do \strong{not} supply \code{x} or
\code{n_iter} here; these are set internally by \code{quantize_commsim()}.
See \code{\link[=quantize]{quantize()}} for details.}
}
\value{
An object of class \code{"commsim"} suitable for
\code{\link[vegan:nullmodel]{vegan::nullmodel()}} and \code{\link[vegan:oecosimu]{vegan::oecosimu()}}.
}
\description{
Construct a \code{\link[vegan:commsim]{vegan::commsim()}} object that uses \code{\link[=quantize]{quantize()}} as a
non-sequential null model for numeric community matrices.
Each simulated matrix is generated independently by applying
\code{\link[=quantize]{quantize()}} with \code{n_iter} trades (via its internal call to
\code{\link[=nullcat]{nullcat()}}) starting from the original matrix.
}
\section{Details}{


This generates a commsim object that is \strong{non-sequential}:
each simulated matrix starts from the original matrix and is
randomized independently using \code{n_iter} trades of the chosen
\code{method}.

When used via \code{vegan::simulate.nullmodel()}, the arguments behave as:
\itemize{
\item \code{nsim}: number of simulated matrices to generate.
\item \code{n_iter} (here, in \code{nullcat_commsim()}): number of trades per
simulated matrix (controls how strongly each replicate is shuffled).
\item \code{burnin} and \code{thin}: are \strong{ignored} for this commsim, because
\code{isSeq = FALSE} (the simulations are not a Markov chain).
}

In other words, treat \code{n_iter} as the tuning parameter for how
thoroughly each independent null matrix is randomized.
}

\examples{
\dontshow{if (requireNamespace("vegan", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
  library(vegan)

  x <- matrix(rexp(50), 10, 5)

  cs <- quantize_commsim(
    n_strata = 10,
    method   = "curvecat",
    n_iter   = 1000L
  )

  nm   <- nullmodel(x, cs)
  sims <- simulate(nm, nsim = 999)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=quantize_batch]{quantize_batch()}} if you just want a batch of null matrices
without going through \strong{vegan}.
}
