% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzffdr_clean.R
\name{nzffdr_clean}
\alias{nzffdr_clean}
\title{Clean NZ Freshwater Fish Datasets}
\usage{
nzffdr_clean(fishd)
}
\arguments{
\item{fishd}{a dataframe imported from the NZFFD using \code{nzffdr_import()}}
}
\value{
A cleaned NZFFD dataframe.
}
\description{
Clean up data imported from the NZ Freshwater Fish Database.
}
\details{
Cleans up a few inconsistencies in the NZFFD data returned from
 \code{nzffd_import()}. Column types are checked and converted to, integer,
 numeric or character. Empty cells are filled with NA, variable `catchmentName`
 entries are standardised (e.g. Clutha r, Clutha River and Clutha R all
 become Clutha R) and, any empty columns are removed.
}
\examples{
nzffdr_clean(nzffdr::nzffdr_data)

}
