% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentLabels.R
\name{fragmentLabels}
\alias{fragmentLabels}
\title{Gets annotations in fragments.}
\usage{
fragmentLabels(
  matches,
  layer.ids,
  sep = " ",
  partial.containment = FALSE,
  no.progress = FALSE,
  start.column = Line,
  end.column = LineEnd,
  labbcat.url = NULL,
  column.prefix = NULL
)
}
\arguments{
\item{matches}{A dataframe returned by \link{getMatches} or \link{getAllUtterances}, identifying
the results to which acoustic measurments should be appended.}

\item{layer.ids}{A vector of layer IDs.}

\item{sep}{The separator to use when concatenating labels when multiple annotations are
in the given interval.}

\item{partial.containment}{Whether to include annotations that are only partially
contained in the given interval.}

\item{no.progress}{TRUE to suppress visual progress bar. Otherwise, progress bar will be
shown when interactive().}

\item{start.column}{The column of \code{matches} containing the start time in seconds.}

\item{end.column}{The column of \code{matches} containing the end time in seconds.}

\item{labbcat.url}{URL to the LaBB-CAT instance (instead of inferring it from \code{matches}).}

\item{column.prefix}{A string to prefix each new column name with.}
}
\value{
\code{matches} with the acoustic measurements appended as new columns.
}
\description{
This is a version of \link{getFragmentAnnotations} that can have a
dataframe of matches piped into it.
}
\details{
It gets annotations between given start/end times on given layers. If more
than one annotation matches, labels are concatentated together.
}
\examples{
\dontrun{
## Get all tokens of /I/
results <- getMatches(labbcat.url, list(topic = ".*quake.*")) |>
    fragmentLabels( ## concatenate labels of words between topic.start and topic.end
       c("word"), start.column=topic.start, end.column=topic.end)
}
}
\seealso{
\itemize{
\item \link{processWithPraat}
\item \link{getMatches}
}

Other Praat-related functions: 
\code{\link{appendFromPraat}()},
\code{\link{fragmentTranscripts}()},
\code{\link{praatScriptCentreOfGravity}()},
\code{\link{praatScriptFastTrack}()},
\code{\link{praatScriptFormants}()},
\code{\link{praatScriptIntensity}()},
\code{\link{praatScriptPitch}()},
\code{\link{processWithPraat}()}
}
\concept{Praat-related functions}
\keyword{praat}
