% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_fine-tuning.R
\name{fine_tuning_cancel_job_request}
\alias{fine_tuning_cancel_job_request}
\title{API fine-tuning: cancel fine-tuning job request}
\usage{
fine_tuning_cancel_job_request(fine_tuning_job_id, api_key = api_get_key())
}
\arguments{
\item{fine_tuning_job_id}{string, the ID of the fine-tuning job to cancel}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Immediately cancel a fine-tune job. To get more details, visit
https://platform.openai.com/docs/guides/fine-tuning
https://platform.openai.com/docs/api-reference/fine-tuning/cancel
}
\examples{
\dontrun{
res_content <- fine_tuning_cancel_job_request("job-id")
if (!is_error(res_content)) {
  message("job canceled")
}
}

}
