% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_threads.R
\name{threads_modify_thread_request}
\alias{threads_modify_thread_request}
\title{API threads: modify thread}
\usage{
threads_modify_thread_request(
  thread_id,
  metadata = NULL,
  api_key = api_get_key()
)
}
\arguments{
\item{thread_id}{string, the ID of the thread to modify. Only the `metadata` can be modified.}

\item{metadata}{NULL/list, set of 16 key-value pairs that can be attached to an object. This can be useful for
storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long
and values can be a maximum of 512 characters long.}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Modifies a thread. To get more details, visit
https://platform.openai.com/docs/api-reference/threads/modifyThread
https://platform.openai.com/docs/assistants
}
