% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmaxcount.R, R/dmaxcount.all.R, R/pmaxcount.R,
%   R/qmaxcount.R, R/rmaxcount.R
\name{dmaxcount}
\alias{dmaxcount}
\alias{dmaxcount.all}
\alias{pmaxcount}
\alias{qmaxcount}
\alias{rmaxcount}
\title{The Maximum-Count Occupancy Distribution}
\usage{
dmaxcount(x, size, space, prob = 1, log = FALSE)

dmaxcount.all(max.x, max.size, space, prob = 1, log = FALSE)

pmaxcount(q, size, space, prob = 1, log.p = FALSE, lower.tail = TRUE)

qmaxcount(p, size, space, prob = 1, log.p = FALSE, lower.tail = TRUE)

rmaxcount(n, size, space, prob = 1)
}
\arguments{
\item{x}{vector of quantiles.}

\item{size}{The size parameter for the maximum-count distribution (number of balls)}

\item{space}{The space parameter for the maximum-count distribution (number of bins)}

\item{prob}{The probability parameter for the occupancy distribution (probability of ball occupying its bin)}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{max.x}{A vector of numeric values to be used as arguments for the probability mass function}

\item{max.size}{The maximum size parameter for the maximum-count distribution (number of balls)}

\item{q}{vector of quantiles.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
If all inputs are correctly specified (i.e., parameters are in allowable range) then the output will be a
vector of probabilities/log-probabilities up to the maximum argument values
}
\description{
Density, distribution function, quantile function and random generation for
the maximum count occupancy distribution with size and shape parameters.
}
\details{
\code{dmaxcount.all} returns the entire PMF.

This function computes probabilities or log-probabilities from the probability mass function of the maximum-count
distribution, which is the distribution for the maximum of the counts for the number of balls in a bin in the extended
occupancy problem.  Details of the algorithm in the classical case can be found in the papers below.  The extension
to include the probability parameter is done using the binomial mixture representation of the extended occupancy problem.
}
\section{References}{


Bonetti, M., Corillo, P. and Ogay, A. (2019) Computing the exact distributions of some functions of the ordered multinomial
counts: maximum, minimum, range and sums of order statistics.

Rappeport, M,A. (1968) Algorithms and computational procedures for the application of order statistics to queuing
problems. PhD thesis, New York University.
}

\examples{
x <- rmaxcount(10, 2, 2)
p <- pmaxcount(x, 2, 2)
stopifnot(x == qmaxcount(p, 2, 2))
dmaxcount.all(2,2,2)
}
