% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docc.R, R/docc.all.R, R/pocc.R, R/qocc.R,
%   R/rocc.R
\name{docc}
\alias{docc}
\alias{docc.all}
\alias{pocc}
\alias{qocc}
\alias{rocc}
\title{The Extended Occupancy Distribution}
\usage{
docc(x, size, space, prob = 1, approx = FALSE, log = FALSE)

docc.all(max.size, space, prob = 1, approx = FALSE, log = FALSE)

pocc(
  x,
  size,
  space,
  prob = 1,
  approx = FALSE,
  log.p = FALSE,
  lower.tail = TRUE
)

qocc(
  p,
  size,
  space,
  prob = 1,
  approx = FALSE,
  log.p = FALSE,
  lower.tail = TRUE
)

rocc(n, size, space, prob = 1)
}
\arguments{
\item{x}{vector of quantiles.}

\item{size}{The size parameter for the occupancy distribution (number of balls)}

\item{space}{The space parameter for the occupancy distribution (number of bins)}

\item{prob}{The probability parameter for the occupancy distribution (probability of ball occupying its bin)}

\item{approx}{A logical value specifying whether to use the normal approximation to the occupancy distribution}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{max.size}{The maximum size parameter for the occupancy distribution (number of balls)}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
If all inputs are correctly specified (i.e., parameters are in allowable range and arguments are integers)
then the output will be a vector of probabilities/log-probabilities corresponding to the vector argument x
}
\description{
Density, distribution function, quantile function and random generation
for the extended occupancy distribution with size and shape parameters.
}
\details{
\code{docc.all} returns the entire PMF.
}
\section{References}{


O'Neill, B. (2021) Three distributions in the extended occupancy problem.
}

\examples{
x <- rocc(10, 2, 2)
p <- pocc(x, 2, 2)
stopifnot(x == qocc(p, 2, 2))
docc.all(2,2)
}
