% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{oceRenameMetadata}
\alias{oceRenameMetadata}
\title{Rename Something in the metadata Slot of an oce Object}
\usage{
oceRenameMetadata(object, old, new, note = "")
}
\arguments{
\item{object}{an \linkS4class{oce} object.}

\item{old}{character value that matches the name of an item in \code{object}'s \code{metadata} slot.}

\item{new}{character value to be used as the new name that matches the name of an item in
\code{object}'s \code{metadata} slot. Thus must not be the name of something that is already in the \code{metadata}
slot. If \code{new} is the  same as \code{old}, then the object is returned unaltered.}

\item{note}{character value that holds an explanation of the reason for the change. If this
is a string of non-zero length, then this is inserted in the processing log of the returned
value. If it is \code{NULL}, then no entry is added to the processing log.  Otherwise, the processing
log gets a new item that is constructed from the function call.}
}
\description{
Rename an item within the \code{metadata} slot of an \linkS4class{oce} object.
}
\seealso{
Other things related to the metadata slot: 
\code{\link{oceDeleteMetadata}()},
\code{\link{oceGetMetadata}()},
\code{\link{oceSetMetadata}()}
}
\author{
Dan Kelley
}
\concept{things related to the metadata slot}
