% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{summary.ocf.marginal}
\alias{summary.ocf.marginal}
\title{Summary Method for ocf.marginal Objects}
\usage{
\method{summary}{ocf.marginal}(object, latex = FALSE, ...)
}
\arguments{
\item{object}{An \code{ocf.marginal} object.}

\item{latex}{If \code{TRUE}, prints LATEX code.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Summarizes an \code{ocf.marginal} object.
}
\description{
Summarizes an \code{ocf.marginal} object.
}
\details{
Compilation of the LATEX code requires the following packages: \code{booktabs}, \code{float}, \code{adjustbox}. If
standard errors have been estimated, they are printed in parenthesis below each point estimate.
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_ordered_data(100)
sample <- data$sample
Y <- sample$Y
X <- sample[, -1]

## Fit ocf.
forests <- ocf(Y, X)

## Marginal effects at the mean.
me <- marginal_effects(forests, eval = "atmean")
summary(me)
summary(me, latex = TRUE)

## Add standard errors.
honest_forests <- ocf(Y, X, honesty = TRUE)
honest_me <- marginal_effects(honest_forests, eval = "atmean", inference = TRUE)
summary(honest_me, latex = TRUE)}

}
\references{
\itemize{
  \item Di Francesco, R. (2025). Ordered Correlation Forest. Econometric Reviews, 1–17. \doi{10.1080/07474938.2024.2429596}.
}
}
\seealso{
\code{\link{ocf}}, \code{\link{marginal_effects}}.
}
\author{
Riccardo Di Francesco
}
