% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_data.frame.R
\name{round_data.frame}
\alias{round_data.frame}
\title{Round \code{numeric} columns of a \code{data.frame}}
\usage{
round_data.frame(df, digits = 0)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
A \code{data.frame}.}

\item{digits}{[\code{integer(1)} | \code{NULL} ]\cr
The number of decimal places to be used.

Negative values are allowed, resulting in rounding to a power of ten.

Can be \code{NULL} to not round.}
}
\value{
A \code{data.frame}.
}
\description{
This function rounds (only) the \code{numeric} columns of a
\code{data.frame}.
}
\examples{
df <- data.frame("label" = c("A", "B"), "number" = rnorm(10))
round_data.frame(df, digits = 1)
}
\seealso{
Other data.frame helpers: 
\code{\link{delete_columns_data.frame}()},
\code{\link{group_data.frame}()},
\code{\link{occurrence_info}()}
}
\concept{data.frame helpers}
\keyword{transformation}
