% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{check_ortho_with_chars}
\alias{check_ortho_with_chars}
\title{Check the orthogonality with field/topographic characteristics}
\usage{
check_ortho_with_chars(td, sp_data_list, vars_list)
}
\arguments{
\item{td}{(tibble) trial design data created by make_exp_plots() and assign_rates()}

\item{sp_data_list}{(list) list of spatial datasets as `sf` from the `sf` package or `SpatRaster` from the `terra` package}

\item{vars_list}{(list) list of character vectors indicating the name of the variables to be used in the datasets specified in sp_data_list}
}
\value{
a list
}
\description{
Check the orthogonality of the trial input rates and observed characteristics provided by the user
}
\examples{
\donttest{
data(td_single_input)

ssurgo_sf <-
  sf::st_read(system.file("extdata", "ssurgo-simple1.shp", package = "ofpetrial")) \%>\%
  dplyr::mutate(mukey = factor(mukey))

checks <-
  check_ortho_with_chars(
    td = td_single_input,
    sp_data_list = list(ssurgo_sf),
    vars_list = list("clay")
  )

checks$summary_data[[1]]

checks$summary_fig[[1]]
}
}
