% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_plot_info.R
\name{prep_plot}
\alias{prep_plot}
\title{Prepare plot information for a single-input experiment (length in meter)}
\usage{
prep_plot(
  input_name,
  unit_system,
  machine_width,
  section_num,
  harvester_width,
  plot_width = NA,
  headland_length = NA,
  side_length = NA,
  max_plot_width = NA,
  min_plot_length = NA,
  max_plot_length = NA
)
}
\arguments{
\item{input_name}{(character) Input name}

\item{unit_system}{(character) A character of either 'metric' or 'imperial' indicating the system of measurement used}

\item{machine_width}{(numeric) A numeric number in units specified in unit_system that indicates the width of the applicator or planter of the input}

\item{section_num}{(numeric) A numeric number that indicates the number of sections of the applicator or planter of the input}

\item{harvester_width}{(numeric) A numeric number that indicates the width of the harvester}

\item{plot_width}{(numeric) Default is c(NA, NA).}

\item{headland_length}{(numeric) A numeric number that indicates the length of the headland (how long the non-experimental space is in the direction machines drive). Default is NA.}

\item{side_length}{(numeric) A numeric number that indicates the length of the two sides of the field (how long the non-experimental space is in the direction perpendicular to the direction of machines). Default is NA.}

\item{max_plot_width}{(numeric) Maximum width of the plots. Default is 36.576 meter (120 feet).}

\item{min_plot_length}{(numeric) Minimum length of the plots. Default is 73.152 meter (240 feet).}

\item{max_plot_length}{(numeric) Maximum length of the plots. Default is 91.440 meter (300 feet)}
}
\value{
a tibble with plot information necessary to create experiment plots
}
\description{
Prepare plot information for a single-input experiment case. All the length values need to be specified in meter.
}
\examples{
input_name <- "seed"
unit_system <- "metric"
machine_width <- 12
section_num <- 12
plot_width <- NA
harvester_width <- 24
prep_plot(input_name, unit_system, machine_width, section_num, harvester_width)

}
