% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attrs_pres.R
\name{svg_attrs_pres}
\alias{svg_attrs_pres}
\title{Define SVG presentation attributes for an element}
\usage{
svg_attrs_pres(
  stroke = NULL,
  stroke_width = NULL,
  stroke_opacity = NULL,
  fill = NULL,
  fill_opacity = NULL,
  font_family = NULL,
  font_size = NULL,
  font_weight = NULL,
  font_style = NULL,
  text_decoration = NULL,
  transform = NULL,
  filter = NULL,
  mask = NULL,
  clip_path = NULL,
  clip_rule = NULL,
  stroke_dasharray = NULL,
  stroke_dashoffset = NULL,
  stroke_linecap = NULL,
  stroke_linejoin = NULL,
  stroke_miterlimit = NULL,
  fill_rule = NULL,
  color = NULL,
  opacity = NULL,
  color_interpolation = NULL,
  color_interpolation_filters = NULL,
  lighting_color = NULL,
  flood_color = NULL,
  flood_opacity = NULL,
  stop_color = NULL,
  stop_opacity = NULL,
  font_variant = NULL,
  font_stretch = NULL,
  font_size_adjust = NULL,
  text_anchor = NULL,
  letter_spacing = NULL,
  word_spacing = NULL,
  dominant_baseline = NULL,
  alignment_baseline = NULL,
  baseline_shift = NULL,
  direction = NULL,
  writing_mode = NULL,
  overflow = NULL,
  marker_start = NULL,
  marker_mid = NULL,
  marker_end = NULL,
  pointer_events = NULL,
  cursor = NULL,
  vector_effect = NULL,
  shape_rendering = NULL,
  color_rendering = NULL,
  text_rendering = NULL,
  image_rendering = NULL,
  display = NULL,
  visibility = NULL
)
}
\arguments{
\item{stroke}{The color used to paint the outline of the shape.}

\item{stroke_width}{The width of the stroke to be applied to the shape. Can
be expressed in \code{px} or percentage units.}

\item{stroke_opacity}{The opacity of the stroke of a shape. We can use a real
number from \code{0} to \code{1} or a value in percentage units.}

\item{fill}{The color used to fill the inside of the element.}

\item{fill_opacity}{The opacity of the color or the content the current
object is filled with. We can use a real number from \code{0} to \code{1} or a value
in percentage units.}

\item{font_family}{Which font family will be used to render the text of the
element?}

\item{font_size}{The size of the font.}

\item{font_weight}{The weight or boldness of the font. Possible values are
\code{"normal"}, \code{"bold"}, \code{"lighter"}, \code{"bolder"}, and the values \code{100}, \code{200},
and so on, up to \code{900}.}

\item{font_style}{Whether a font should be styled with a \code{"normal"},
\code{"italic"}, or \code{"oblique"} face from its \code{font_family}.}

\item{text_decoration}{Add decorative lines on text. Options are
\code{"underline"}, \code{"overline"}, \code{"line-through"}, and \code{"blink"}.}

\item{transform}{A list of transform definitions that are applied to an
element and the element's children.}

\item{filter}{The filter effects defined by a \verb{<filter>} element that shall
be applied to its element. Requires a reference to a \verb{<filter>} \code{id}
attribute.}

\item{mask}{The mask defined by a \verb{<mask>} element that shall be applied to
its element. Requires a reference to a \verb{<mask>} \code{id} attribute.}

\item{clip_path}{The clipping path defined by a \verb{<clipPath>} element that
shall be applied to its element. Requires a reference to a \verb{<clipPath>}
\code{id} attribute.}

\item{clip_rule}{A rule for determining what side of a path is inside of a
shape in order to know how \code{clip_path} should clip its target.
Options are \code{"nonzero"}, \code{"evenodd"}, and \code{"inherit"}.}

\item{stroke_dasharray}{The pattern of dashes and gaps used to paint the
outline of the shape.}

\item{stroke_dashoffset}{Defines an offset on the rendering of the associated
dash array.}

\item{stroke_linecap}{The shape to be used at the end of open subpaths when
they are stroked. We can use the options \code{"butt"}, \code{"round"}, or
\code{"square"}.}

\item{stroke_linejoin}{The shape to be used at the corners of paths when they
are stroked (\code{"arcs"}, \code{"bevel"}, \code{"miter"}, \code{"miter-clip"}, and
\code{"round"}).}

\item{stroke_miterlimit}{The limit on the ratio of the miter length to the
\code{stroke_width} Used to draw a miter join. A numeric value should be used
to define the limit.}

\item{fill_rule}{A rule for determining what side of a path is inside of a
shape. Options are \code{"nonzero"}, \code{"evenodd"}, and \code{"inherit"}.}

\item{color}{Potentially provides an indirect value (as the \code{currentColor})
for \code{fill}, \code{stroke}, \code{stop_color}, \code{flood_color} and \code{lighting_color}
options.}

\item{opacity}{Specifies the transparency of an object or a group of objects.
We can use a real number from \code{0} to \code{1} or a value in percentage units.}

\item{color_interpolation}{The color space for gradient interpolations, color
animations, and alpha compositing. Allowed values are: \code{"auto"}, \code{"sRGB"},
\code{"linearRGB"}, and \code{"inherit"}.}

\item{color_interpolation_filters}{The color space for imaging operations
performed via filter effects. Allowed values are: \code{"auto"}, \code{"sRGB"},
\code{"linearRGB"}, and \code{"inherit"}.}

\item{lighting_color}{The color of the light source for filter primitives
elements \verb{<feSpecularLighting>} and \verb{<feDiffuseLighting>}.}

\item{flood_color, flood_opacity}{The color and opacity level to use to flood
the current filter primitive subregion defined through the \verb{<feFlood>} or
\verb{<feDropShadow>} element.}

\item{stop_color, stop_opacity}{Sets the color and opacity at a gradient stop.}

\item{font_variant}{Determines whether a font should be used with some of
their variation such as small caps or ligatures.}

\item{font_stretch}{Allows for a selection of a normal, condensed, or
expanded face from a font.}

\item{font_size_adjust}{Specifies that the font size should be chosen based
on the height of lowercase letters rather than the height of capital
letters.}

\item{text_anchor}{The vertical alignment a string of text. We can use the
values \code{"start"}, \code{"middle"}, \code{"end"}, or \code{"inherit"}.}

\item{letter_spacing, word_spacing}{The spacing between text characters and
between words.}

\item{dominant_baseline}{The baseline used to align the box’s text and
inline-level contents. The options for this are: \code{"auto"}, \code{"text-bottom"},
\code{"alphabetic"}, \code{"ideographic"}, \code{"middle"}, \code{"central"}, \code{"mathematical"},
\code{"hanging"}, and \code{"text-top"}.}

\item{alignment_baseline}{Determines how an object is to be aligned along the
font baseline with respect to its parent. Allowed values are: \code{"auto"},
\code{"baseline"}, \code{"before-edge"}, \code{"text-before-edge"}, \code{"middle"},
\code{"central"}, \code{"after-edge"}, \code{"text-after-edge"}, \code{"ideographic"},
\code{"alphabetic"}, \code{"hanging"}, \code{"mathematical"}, and \code{"inherit"}.}

\item{baseline_shift}{An option for repositioning of the dominant-baseline
relative to the dominant-baseline of the parent text content element. Valid
options are: \code{"auto"}, \code{"baseline"}, \code{"super"}, \code{"sub"}, \code{"inherit"}, a
length value, or a percentage value.}

\item{direction}{The base writing direction of text. Can be either \code{"ltr"},
\code{"rtl"}, or \code{"inherit"}.}

\item{writing_mode}{The initial inline-progression-direction for a \verb{<text>}
element (can be left-to-right, right-to-left, or top-to-bottom). Valid
values are \code{"lr-tb"}, \code{"rl-tb"}, \code{"tb-rl"}, \code{"lr"}, \code{"rl"}, \code{"tb"}, or
\code{"inherit"}.}

\item{overflow}{The overflow behavior for the content of a block-level
element when it overflows the element's box. Options are: \code{"visible"},
\code{"hidden"}, \code{"scroll"}, \code{"auto"}, and \code{"inherit"}.}

\item{marker_start, marker_mid, marker_end}{The arrowhead or polymarker that
will be drawn at the first node, the final node, or, the in-between nodes.
This applies to a \verb{<path>} element or a basic shape. These attributes can
be applied to any element but only have an effect on the following seven
elements: \verb{<rect>}, \verb{<circle>}, \verb{<ellipse>}, \verb{<line>}, \verb{<path>},
\verb{<polygon>}, and \verb{<polyline>}. Requires a reference to a \verb{<marker>} \code{id}
attribute (defined within the SVG's \verb{<defs>} area).}

\item{pointer_events}{Defines whether or when an element may be the target of
a mouse event. Options are: \code{"bounding-box"}, \code{"visiblePainted"},
\code{"visibleFil"}, \code{"visibleStroke"}, \code{"visible"}| \code{"painted"}, \code{"fill"},
\code{"stroke"}, \code{"all"}, and \code{"none"}.}

\item{cursor}{The mouse cursor displayed when the mouse pointer is over an
element.}

\item{vector_effect}{The vector effect to use when drawing an object. Options
are: \code{"default"}, \code{"non-scaling"}, \code{"stroke"}, and \code{"inherit"}.}

\item{shape_rendering, color_rendering, text_rendering, image_rendering}{A
quality setting parameter for shapes, color interpolation and compositing,
text, and image processing. All of the rendering attributes can use the
\code{"auto"} and \code{"optimizeSpeed"} directives. For shape rendering, we can
elect for \code{"crispEdges"}, \code{"geometricPrecision"}, or just \code{"inherit"}. When
rendering color, additional choices are \code{"optimizeQuality"} and
\code{"inherit"}. Text rendering allows us the additional
\code{"optimizeLegibility"}, \code{"geometricPrecision"}, and \code{"inherit"} options.
With image rendering, we can furthermore choose to \code{"optimizeSpeed"}.}

\item{display}{Allows for control of the rendering of graphical or container
elements. A value of \code{"none"} indicates that the given element and its
children will not be rendered. Any value other than \code{"none"} or \code{"inherit"}
indicates that the given element will be rendered by the browser.}

\item{visibility}{The visibility attribute lets us control the visibility of
graphical elements. With a value of \code{"hidden"} or \code{"collapse"}, the element
is invisible.}
}
\value{
A named list of presentational SVG properties. This object can be
used as a value for the \code{attrs} argument, which is present in every SVG
element function (e.g,. \code{\link[=svg_rect]{svg_rect()}}).
}
\description{
The \code{svg_attrs_pres()} helper function can be used to more easily generate a
valid presentation attribute list for the \code{attrs} argument that is present
in every SVG element function (e.g., \code{\link[=svg_rect]{svg_rect()}}, \code{\link[=svg_text]{svg_text()}}, etc.). All
of the presentation attributes formally included here as options can be
animated.
}
