% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeXZy.R
\name{makeXZy}
\alias{makeXZy}
\title{Prepare Design Matrices and Response Vector}
\usage{
makeXZy(formula, df)
}
\arguments{
\item{formula}{A symbolic description of the model, where the left-hand side specifies 
the response variable and the right-hand side specifies predictors. 
Formulas can include a `|` operator to separate predictors for different components of a model.}

\item{df}{A data frame containing the variables specified in the formula.}
}
\value{
A list containing the following components:
\describe{
  \item{\code{X}}{A design matrix for the main predictors.}
  \item{\code{Z}}{A design matrix for additional predictors (e.g., for a secondary process in 
    a two-component model).}
  \item{\code{y}}{The response vector extracted from the formula.}
}
}
\description{
Processes a model formula and a data frame to generate design matrices (`X` and `Z`) 
and a response vector (`y`) for regression models, including support for complex 
formulas with `|` operators.
}
\details{
This function processes the formula to extract and construct:
- `X`: The main design matrix.
- `Z`: A secondary design matrix (if a `|` operator is used in the formula, separating components).
- `y`: The response variable.

It handles cases where the formula specifies:
- Only the main component (e.g., \code{y ~ x1 + x2}).
- A secondary component using the `|` operator (e.g., \code{y ~ x1 + x2 | z1 + z2}).
}
\seealso{
\code{\link{model.matrix}}, \code{\link{model.frame}}, \code{\link{model.response}}
}
