% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_summ_route.R
\name{get_summ_route}
\alias{get_summ_route}
\title{Get Summary Route Information}
\usage{
get_summ_route(
  token,
  start,
  end,
  route,
  date = format(Sys.Date(), "\%m-\%d-\%Y"),
  time = format(Sys.time(), "\%T"),
  mode = NULL,
  max_dist = NULL,
  route_geom = FALSE
)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{start}{Vector of c(lat, lon) coordinates for the route start point}

\item{end}{Vector of c(lat, lon) coordinates for the route end point}

\item{route}{Type of route. Accepted values are \code{walk}, \code{drive}, \code{pt} (public transport), or \code{cycle}}

\item{date}{Default = current date. Date for which route is requested.}

\item{time}{Default = current time. Time for which route is requested.}

\item{mode}{Required if \code{route = "pt"}. Accepted values are \code{TRANSIT}, \code{BUS} or \code{RAIL}}

\item{max_dist}{Optional if \code{route = "pt"}. Maximum walking distance}

\item{route_geom}{Default = FALSE. Whether to return decoded route_geometry. Please ensure packages \pkg{googlePolylines} and \pkg{sf} are installed and note that this is a lossy conversion.}
}
\value{
If no error occurs, a tibble of 1 x 2 with the variables:
\describe{
  \item{total_time}{The total time taken for this route}
  \item{total_dist}{The total distance travelled for this route}
}

If an error occurs, the output will be \code{NA}, along with a warning message.
}
\description{
This function is a wrapper for the \href{https://www.onemap.gov.sg/apidocs/routing/}{Route Service API}. However, it only returns the total time, distance and optionally the route geometry between two points.
If \code{route = "pt"}, only the best route is chosen (i.e. \code{n_itineraries = 1}).
}
\examples{
# returns output tibble
\dontrun{get_summ_route(token, c(1.320981, 103.844150), c(1.326762, 103.8559), "drive")}
\dontrun{get_summ_route(token, c(1.320981, 103.844150), c(1.326762, 103.8559), "pt",
    mode = "bus", max_dist = 300)}

# returns output sf dataframe
\dontrun{get_summ_route(token, c(1.320981, 103.844150), c(1.326762, 103.8559),
    "drive", route_geom = TRUE)}
\dontrun{get_summ_route(token, c(1.320981, 103.844150), c(1.326762, 103.8559), "pt",
    mode = "bus", max_dist = 300, route_geom = TRUE)}
#'
# error: output is NULL, warning message shows status code
\dontrun{get_summ_route("invalid_token", c(1.320981, 103.844150), c(1.326762, 103.8559), "drive")}

# error: output is NULL, warning message shows error message from request
\dontrun{get_summ_route(token, c(300, 300), c(400, 500), "cycle")}
\dontrun{get_summ_route(token, c(1.320981, 103.844150), c(1.326762, 103.8559), "fly")}
}
