% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onetime.R
\name{onetime_do}
\alias{onetime_do}
\title{Run code only once}
\usage{
onetime_do(
  expr,
  id = deprecate_calling_package(),
  path = default_lockfile_dir(),
  expiry = NULL,
  default = NULL,
  without_permission = c("warn", "run", "stop", "pass", "ask")
)
}
\arguments{
\item{expr}{The code to evaluate. An R statement or \code{\link[=expression]{expression()}} object.}

\item{id}{Unique ID string. If this is unset, the name of the calling
package will be used. Since onetime 0.2.0, not setting \code{id} is
deprecated.}

\item{path}{Directory to store lockfiles. The default uses a unique
directory corresponding to the calling package, beneath
\code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}. Normally you should leave this as the
default.}

\item{expiry}{\code{\link[=difftime]{difftime()}} or e.g. \code{\link[lubridate:duration]{lubridate::duration()}} object.
After this length of time, code will be run again.}

\item{default}{Value to return if \code{expr} was not executed.}

\item{without_permission}{Character string. What to do if the user hasn't
given permission to store files? \code{"warn"} runs the action with an extra
warning; \code{"run"} runs the action with no warning; \code{"pass"} does nothing
and returns the default; \code{"stop"} throws an error; \code{"ask"} asks for
permission using \code{\link[=check_ok_to_store]{check_ok_to_store()}}, and returns the default if it is
not granted.}
}
\value{
\code{onetime_do()} invisibly returns the value of \code{expr},
or \code{default} if \code{expr} was not run because it had been run already.
}
\description{
When first called, \code{onetime_do()} evaluates an expression. It then creates a
lockfile recording a unique ID which will prevent the expression being run
on subsequent calls.
}
\details{
\code{onetime_do()} is the engine used by other onetime functions.

Calls are identified by \code{id}. If you use the same value of \code{id} across
different calls to onetime functions, only the first call will get made.

The default \code{path}, where lockfiles are stored, is in a per-package directory
beneath \code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}. To use a different subdirectory within
the onetime base directory, set \code{path = onetime_dir("dirname")}.

End users can also set \code{options(onetime.dir)} to change the base directory.
Package authors should only set this option locally within package functions,
if at all.

If the call gives an error, the lockfile is still written.

\code{expiry} is backward-looking. That is, \code{expiry} is used at check time to see
if the lockfile was written after \code{Sys.time() - expiry}. It is not used when
the lockfile is created. So, you should set \code{expiry} to the same value
whenever you call \code{onetime_do()}. See the example.
}
\examples{
oo <- options(onetime.dir = tempdir(check = TRUE))
id <- sample(10000L, 1L)

for (n in 1:3) {
  onetime_do(print("printed once"), id = id)
}

# expiry is "backward-looking":
id2 <- sample(10000L, 1L)
expiry <- as.difftime(1, units = "secs")
onetime_do(print("Expires quickly, right?"), id = id2, expiry = expiry)
Sys.sleep(2)
onetime_do(print("This won't be shown..."), id = id2)
onetime_do(print("... but this will"), id = id2, expiry = expiry)


onetime_reset(id = id)
onetime_reset(id = id2)
options(oo)
}
