% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.list.R
\name{as.data.list}
\alias{as.data.list}
\alias{as.data.list.data.frame}
\title{Convert to data.list class}
\usage{
as.data.list(object)

\method{as.data.list}{data.frame}(object)
}
\arguments{
\item{object}{The data.frame to be converted.}
}
\value{
a value of class data.list

a data.list
}
\description{
These functions will convert the object into a data.list.

Convert a data.frame into a data.list
}
\details{
A data.list is simply a list of vectors and data.frames. For the use in the 
onlineforecast package the following format must be kept:

  - t: A vector of time.

  - vectors with same length as t: Holds observations and values synced to time t.

  - data.frames with number of rows as time t: Holds forecasts in each column named by \code{kxx} where \code{xx} is the
                                               horizon, e.g. \code{k0} is synced as observations, and \code{k1} is one-step ahead.

The convention is that columns with forecasts are postfixed with \code{.kxx} where
\code{xx} is the horizon. See the examples.
}
\examples{
# Convert a dataframe with time and two observed variables
X <- data.frame(t=1:10, x=1:10, y=1:10)
as.data.list(X)

# Convert a dataframe with time, forecast and an observed variable
X <- data.frame(t=1:10, x.k1=1:10, x.k2=10:1, yobs=1:10, y.k1=1:10, y.k2=1:10)
as.data.list(X)

# Can be converted back and forth
X
as.data.frame(as.data.list(X))

}
\seealso{
\code{For specific detailed info see the children, e.g. \link{as.data.list.data.frame} }

as.data.list
}
