#' Data from the two-action games
#'
#' This is the choice data from Kuelpmann and Kuzmics (2022) for the two-action games, i.e., Hawk-Dove and Matching Pennies.
#' For an explanation of the different treatments and the games, please refer to the paper.
#'
#' @format
#' \describe{
#'   \item{rows}{actions}
#'   \item{columns}{treatments}
#'   \item{cells}{number of subjects who chose each action on each treatment}
#'   ...
#' }
#' @source \url{https://homepage.univie.ac.at/philipp.kuelpmann/hdg.html}
"data_two_action_games"

#' Data from the three-action games
#'
#' This is the choice data from Kuelpmann and Kuzmics (2022) for the three-action games, i.e., Hawk-Middle-Dove and Rock-Paper-Scissor.
#' For an explanation of the different treatments and the games, please refer to the paper.
#'
#' @format Need to reformat anyway ...
#' \describe{
#'   \item{rows}{actions}
#'   \item{columns}{treatments}
#'   \item{cells}{number of subjects who chose each action on each treatment}
#'   ...
#' }
#' @source \url{https://homepage.univie.ac.at/philipp.kuelpmann/hdg.html}
"data_three_action_games"


#' Predictions for the two-action games
#'
#' These are the prediction of every theory considered in Kuelpmann and Kuzmics (2022) for the two-action games.
#' For a explanation of the different theories, treatments and the games, please refer to the paper.
#'
#' @format
#' \describe{
#'   \item{rows}{predicted probabilities of actions}
#'   \item{columns}{treatments}
#'   \item{tables}{different theories}
#'   \item{cells}{probability of choosing an action on each treatment depending on the theory}
#'   ...
#' }
#' @source \url{https://homepage.univie.ac.at/philipp.kuelpmann/hdg.html}
"predictions_two_action_games"


#' Predictions for the three-action games
#'
#' These are the prediction of every theory considered in Kuelpmann and Kuzmics (2022) for the three-action games.
#' For a explanation of the different theories, treatments and the games, please refer to the paper.
#'
#' @format
#' \describe{
#'   \item{rows}{predicted probabilities of actions}
#'   \item{columns}{treatments}
#'   \item{tables}{different theories}
#'   \item{cells}{probability of choosing an action on each treatment depending on the theory}
#'   ...
#' }
#' @source \url{https://homepage.univie.ac.at/philipp.kuelpmann/hdg.html}
"predictions_three_action_games"


#' Simple Test Data
#'
#' This is just very simple test data, mostly used for testing and demonstration purposes.
#'
#' @format A matrix with 3 rows and 2 columns
#' \describe{
#'   \item{rows}{actions}
#'   \item{columns}{treatments}
#'   \item{cells}{number of subjects who chose each action on each treatment}
#'   ...
#' }
"simple_test_data"
