% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitopa.R
\name{opa}
\alias{opa}
\title{Fit an ordinal pattern analysis model}
\usage{
opa(
  dat,
  hypothesis,
  group = NULL,
  pairing_type = "pairwise",
  diff_threshold = 0,
  nreps = 1000L,
  shuffle_across_individuals = FALSE
)
}
\arguments{
\item{dat}{a data frame}

\item{hypothesis}{a numeric vector}

\item{group}{an optional factor vector}

\item{pairing_type}{a string}

\item{diff_threshold}{a positive integer or floating point number}

\item{nreps}{an integer, ignored if \code{cval_method = "exact"}}

\item{shuffle_across_individuals}{a boolean indicating whether to randomize data across individuals in c-value computation.}
}
\value{
\code{opa} returns an object of class "opafit".

An object of class "opafit" is a list containing the folllowing components:
\describe{
  \item{group_pcc}{the percentage of pairwise orderings from all pooled data
  rows which were correctly classified by the hypothesis.}
  \item{individual_pccs}{a vector containing the percentage of pairwise
  orderings that were correctly classified by the hypothesis for each data
  row.}
  \item{correct_pairs}{an integer representing the number of pairwise
  orderings pooled across all data rows that were correctly classified by the
  hypothesis.}
  \item{total_pairs}{an integer, the number of pair orderings contained in
  the data.}
  \item{group_cval}{the group-level chance value.}
  \item{individual_cvals}{a vector containing chance values for each data
  row}
  \item{rand_pccs}{A vector of PCCS calculated from each random ordering
  with length equal to nreps, a list of vectors if a \code{group} vector
  was passed to \code{opa()}.}
  \item{call}{The matched call}
  \item{hypothesis}{The hypothesis vector passed to \code{opa()}}
  \item{pairing_type}{A string indicating the method of pairing passed
  to \code{opa()}.}
  \item{diff_threshold}{The numeric difference threshold used to calculate
  PCCs. If no value was passed in the \code{diff_threshold}, the default of
  0 is used.}
  \item{data}{The data.frame passed to \code{opa()}.}
  \item{groups}{The vector of groups passed to \code{opa}. If no group vector
  was passed to \code{opa()} the default of NULL is used.}
  \item{nreps}{an integer, the number of random re-orderings of the data
  used to compute chance values.}
  }
}
\description{
\code{opa} is used to fit ordinal pattern analysis models by computing the
percentage of pair orderings in each row of data which are matched by
corresponding pair orderings in an hypothesis, in addition the chance of a
permutation of the data producing a percentage match as great.
}
\details{
Data is expected in \strong{wide} format with 1 row per individual and 1
column per measurement condition. Data must contain only columns consisting
of numerical values of the \emph{dependent} variable.

The length of the \code{hypothesis} must be equal to the number of columns in
the dependent variable data.frame \code{dat}.

Any \emph{independent} variable must be passed separately as a vector with the
\code{group} keyword. The grouping vector must be a \emph{factor}.

\code{pairing_type} must be either "pairwise" or "adjacent". The "pairwise"
option considered the relative ordering of every pair of observations in
the data and every pair of elements of the hypothesis. The "adjacent" option
considers the ordering of adjacent pairs only. If unspecified, the default
is "pairwise".

\code{diff_threshold} may be a positive integer or double. If unspecified
a default zero threshold is used. The \code{diff_threshold} is never applied
to the hypothesis.

\code{nreps} specifies the number of random reorderigs to use in the
calculation of chance-values.
}
\examples{
dat <- data.frame(group = c("a", "b", "a", "b"),
                  t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11))
dat$group <- factor(dat$group, levels = c("a", "b"))
h <- hypothesis(1:3)
opamod <- opa(dat[,2:4], h, group = dat$group)
}
\references{
Grice, J. W., Craig, D. P. A., & Abramson, C. I. (2015). A Simple and
Transparent Alternative to Repeated Measures ANOVA. SAGE Open, 5(3),
215824401560419. <https://doi.org/10.1177/2158244015604192>

Thorngate, W. (1987). Ordinal Pattern Analysis: A Method for Assessing
Theory-Data Fit. Advances in Psychology, 40, 345–364.
<https://doi.org/10.1016/S0166-4115(08)60083-7>
}
