% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traj_trajLevelMap.R
\name{trajLevelMap}
\alias{trajLevelMap}
\title{Trajectory level plots in \code{leaflet}}
\usage{
trajLevelMap(
  data,
  longitude = "lon",
  latitude = "lat",
  pollutant,
  type = NULL,
  smooth = FALSE,
  statistic = "frequency",
  percentile = 90,
  lon.inc = 1,
  lat.inc = 1,
  min.bin = 1,
  .combine = NA,
  sigma = 1.5,
  cols = "turbo",
  alpha = 0.5,
  tile.border = NA,
  provider = "OpenStreetMap",
  legend.position = "topright",
  legend.title = NULL,
  legend.title.autotext = TRUE,
  control.collapsed = FALSE,
  control.position = "topright"
)
}
\arguments{
\item{data}{\emph{A data frame containing a HYSPLIT trajectory, perhaps accessed
with \code{\link[openair:importTraj]{openair::importTraj()}}.}

\strong{required}

A data frame containing HYSPLIT model outputs. If this data were not
obtained using \code{\link[openair:importTraj]{openair::importTraj()}}.}

\item{latitude, longitude}{\emph{The decimal latitude/longitude.}

\emph{default:} \code{"lat"} / \code{"lon"}

Column names representing the decimal latitude and longitude.}

\item{pollutant}{Pollutant to be plotted. By default the trajectory height is
used.}

\item{type}{\emph{A method to condition the \code{data} for separate plotting.}

\emph{default:} \code{NULL}

Used for splitting the trajectories into different groups which can be
selected between using a "layer control" menu. Passed to
\code{\link[openair:cutData]{openair::cutData()}}.}

\item{smooth}{Should the trajectory surface be smoothed? Defaults to \code{FALSE}.
Note that, when \code{smooth = TRUE}, no popup information will be available.}

\item{statistic}{Statistic to use for \code{\link[openair:trajLevel]{trajLevel()}}. By default, the function
will plot the trajectory frequencies (\code{statistic = "frequency"}). As an
alternative way of viewing trajectory frequencies, the argument \code{method = "hexbin"} can be used. In this case hexagonal binning of the trajectory
\emph{points} (i.e., a point every three hours along each back trajectory).
The plot then shows the trajectory frequencies uses hexagonal binning.

There are also various ways of plotting concentrations.

It is possible to set \code{statistic = "difference"}. In this case trajectories
where the associated concentration is greater than \code{percentile} are
compared with the the full set of trajectories to understand the
differences in frequencies of the origin of air masses. The comparison is
made by comparing the percentage change in gridded frequencies. For
example, such a plot could show that the top 10\\% of concentrations of PM10
tend to originate from air-mass origins to the east.

If \code{statistic = "pscf"} then a Potential Source Contribution Function map
is produced. This statistic method interacts with \code{percentile}.

If \code{statistic = "cwt"} then concentration weighted trajectories are
plotted.

If \code{statistic = "sqtba"} then Simplified Quantitative Transport Bias
Analysis is undertaken. This statistic method interacts with \code{.combine} and
\code{sigma}.}

\item{percentile}{The percentile concentration of \code{pollutant} against which
the all trajectories are compared.}

\item{lon.inc, lat.inc}{The longitude and latitude intervals to be used for
binning data.}

\item{min.bin}{The minimum number of unique points in a grid cell. Counts
below \code{min.bin} are set as missing.}

\item{.combine}{When statistic is "SQTBA" it is possible to combine lots of
receptor locations to derive a single map. \code{.combine} identifies the column
that differentiates different sites (commonly a column named \code{"site"}).
Note that individual site maps are normalised first by dividing by their
mean value.}

\item{sigma}{For the SQTBA approach \code{sigma} determines the amount of back
trajectory spread based on the Gaussian plume equation. Values in the
literature suggest 5.4 km after one hour. However, testing suggests lower
values reveal source regions more effectively while not introducing too
much noise.}

\item{cols}{The colours used for plotting, passed to
\code{\link[openair:openColours]{openair::openColours()}}. The default, \code{"turbo"}, is a rainbow palette with
relatively perceptually uniform colours. Read more about this palette at
\url{https://research.google/blog/turbo-an-improved-rainbow-colormap-for-visualization/}.}

\item{alpha}{Opacity of the tiles. Must be between \code{0} and \code{1}.}

\item{tile.border}{Colour to use for the border of binned tiles. Defaults to
\code{NA}, which draws no border.}

\item{provider}{\emph{The basemap to be used.}

\emph{default:} \code{"OpenStreetMap"}

A single \link[leaflet:providers]{leaflet::providers}. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list of
all base maps that can be used.}

\item{legend.position}{\emph{Position of the shared legend.}

\emph{default:} \code{"topright"}

Where should the legend be placed? One of "topright", "topright",
"bottomleft" or "bottomright". Passed to the \code{position} argument of
\code{\link[leaflet:addLegend]{leaflet::addLegend()}}. \code{NULL} defaults to "topright".}

\item{legend.title}{\emph{Title of the legend.}

\emph{default:} \code{NULL}

By default, when \code{legend.title = NULL}, the function will attempt to
provide a sensible legend title based on \code{colour}. \code{legend.title} allows
users to overwrite this - for example, to include units or other contextual
information. Users may wish to use HTML tags to format the title.}

\item{legend.title.autotext}{\emph{Automatically format the title of the legend?}

\emph{default:} \code{TRUE}

When \code{legend.title.autotext = TRUE}, \code{legend.title} will be first run
through \code{\link[=quickTextHTML]{quickTextHTML()}}.}

\item{control.collapsed}{\emph{Show the layer control as a collapsed?}

\emph{default:} \code{FALSE}

Should the "layer control" interface be collapsed? If \code{TRUE}, users will
have to hover over an icon to view the options.}

\item{control.position}{\emph{Position of the layer control menu}

\emph{default:} \code{"topright"}

Where should the "layer control" interface be placed? One of "topleft",
"topright", "bottomleft" or "bottomright". Passed to the \code{position}
argument of \code{\link[leaflet:addLayersControl]{leaflet::addLayersControl()}}.}
}
\value{
A leaflet object.
}
\description{
This function plots back trajectories on a \code{leaflet} map. This function
requires that data are imported using the \code{\link[openair:importTraj]{openair::importTraj()}} function.
}
\examples{
\dontrun{
trajLevelMap(traj_data, pollutant = "pm2.5", statistic = "pscf", min.bin = 10)
}

}
\seealso{
\code{\link[openair:trajLevel]{openair::trajLevel()}}

\code{\link[=trajLevelMapStatic]{trajLevelMapStatic()}} for the static \code{ggplot2} equivalent of
\code{\link[=trajLevelMap]{trajLevelMap()}}

Other interactive trajectory maps: 
\code{\link{trajMap}()}
}
\concept{interactive trajectory maps}
