% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_app_connection.R
\name{set_app_connection}
\alias{set_app_connection}
\title{Set Application Database Connection}
\usage{
set_app_connection(dbname, host, port, user, password, ...)
}
\arguments{
\item{dbname}{The name of the database to connect to.}

\item{host}{The host name of the server where the database is located.}

\item{port}{The port number to connect through.}

\item{user}{The username for database authentication.}

\item{password}{The password for database authentication.}

\item{...}{Additional arguments passed to \code{DBI::dbConnect}.}
}
\value{
A database connection object of class \code{DBIConnection}.
}
\description{
Establishes a connection to a PostgreSQL database using provided credentials.
This function utilises the \code{DBI} and \code{RPostgres} packages to set up the connection.
}
\examples{
# Establish a connection to the PostgreSQL database
set_app_connection(
  dbname = "vmc",
  host = "apps-server.idems.international",
  port = 5432,
  user = "vmc",
  password = "LSQkyYg5KzL747"
)

}
\seealso{
\code{\link[DBI]{dbConnect}} for more details on the underlying connection function.
For additional information on database interfaces, see \url{https://dbi.r-dbi.org/}.
}
