% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_config.R
\name{oc_config}
\alias{oc_config}
\title{Configure settings}
\usage{
oc_config(
  key = Sys.getenv("OPENCAGE_KEY"),
  rate_sec = getOption("oc_rate_sec", default = 1L),
  no_record = getOption("oc_no_record", default = TRUE),
  show_key = getOption("oc_show_key", default = FALSE),
  ...
)
}
\arguments{
\item{key}{Your OpenCage API key as a character vector of length one. Do not
pass the key directly as a parameter, though. See details.}

\item{rate_sec}{Numeric vector of length one. Sets the maximum number of
requests sent to the OpenCage API per second. Defaults to the value set in
the \code{oc_rate_sec} option, or, in case that does not exist, to 1L.}

\item{no_record}{Logical vector of length one. When \code{TRUE}, OpenCage will not
create log entries of the queries and will not cache the geocoding
requests. Defaults to the value set in the \code{oc_no_record} option, or, in
case that does not exist, to \code{TRUE}.}

\item{show_key}{Logical vector of length one. This is only relevant when
debugging \code{oc_forward()} or \code{oc_reverse()} calls with the \code{return = "url_only"} argument. When \code{TRUE}, the result will show your OpenCage API
key in the URL as stored in the \code{OPENCAGE_KEY} environment variable. When
not \code{TRUE}, the API key will be replaced with the string \code{OPENCAGE_KEY}.
\code{show_key} defaults to the value set in the \code{oc_show_key} option, or, in
case that does not exist, to \code{FALSE}.}

\item{...}{Ignored.}
}
\description{
Configure session settings for \pkg{opencage}.
}
\section{Set your OpenCage API key}{


\pkg{opencage} will conveniently retrieve your API key if it is saved in the
environment variable \code{"OPENCAGE_KEY"}. \code{\link[=oc_config]{oc_config()}} will help to set that
environment variable. Do not pass the key directly as a parameter to the
function, though, as you risk exposing it via your script or your history.
There are three safer ways to set your API key instead:
\enumerate{
\item Save your API key as an environment variable in
\code{\link[base:Startup]{.Renviron}} as described in \href{https://rstats.wtf/r-startup.html#renviron}{What They Forgot to Teach You About R} or \href{https://csgillespie.github.io/efficientR/set-up.html#renviron}{Efficient R Programming}.
From there it will be fetched by all functions that call the OpenCage API.
You do not even have to call \code{oc_config()} to set your key; you can start
geocoding right away. If you have the \pkg{usethis} package installed, you
can edit your \code{\link[base:Startup]{.Renviron}} with \code{usethis::edit_r_environ()}.
We strongly recommend storing your API key in the user-level .Renviron, as
opposed to the project-level. This makes it less likely you will share
sensitive information by mistake.
\item If you use a package like \pkg{keyring} to store your credentials, you can
safely pass your key in a script with a function call like this
\code{oc_config(key = keyring::key_get("opencage"))}.
\item If you call \code{oc_config()} in an \code{\link[base:interactive]{base::interactive()}} session and the
\code{OPENCAGE_KEY} environment variable is not set, it will prompt you to enter
the key in the console.
}
}

\section{Set your OpenCage API rate limit}{


The rate limit allowed by the API depends on the OpenCage plan you purchased
and ranges from 1 request/sec for the "Free Trial" plan to 15 requests/sec
for the "Medium" or "Large" plans, see \url{https://opencagedata.com/pricing} for
details and up-to-date information. You can set the rate limit persistently
across sessions by setting an \code{oc_rate_sec} \link[base:options]{option} in your
\code{\link[base:Startup]{.Rprofile}}. If you have the \pkg{usethis} package
installed, you can edit your \code{\link[base:Startup]{.Rprofile}} with
\code{usethis::edit_r_profile()}.
}

\section{Prevent query logging and caching}{


By default, OpenCage will store your queries in its server logs and will
cache the forward geocoding requests on their side. They do this in order to
speed up response times and to be able to debug errors and improve their
service. Logs are automatically deleted after six months according to
OpenCage's \href{https://opencagedata.com/gdpr}{page on data protection and GDPR}.

If you set \code{no_record} to \code{TRUE}, the query contents are not logged nor
cached. OpenCage still records that you made a request, but not the specific
query you made. \code{oc_config(no_record = TRUE)} sets the \code{oc_no_record}
\link[base:options]{option} for the active R session, so it will be used for all
subsequent OpenCage queries. You can set the \code{oc_no_record}
\link[base:options]{option} persistently across sessions in your
\code{\link[base:Startup]{.Rprofile}}.

For increased privacy \pkg{opencage} sets \code{no_record} to \code{TRUE}, by default.
Please note, however, that \pkg{opencage} always caches the data it receives
from the OpenCage API locally, but only for as long as your R session is
alive.

For more information on OpenCage's policies on privacy and data protection
see \href{https://opencagedata.com/faq#legal}{their FAQs}, their \href{https://opencagedata.com/gdpr}{GDPR page}, and, for the \code{no_record} parameter, see
the relevant \href{https://blog.opencagedata.com/post/145602604628/more-privacy-with-norecord-parameter}{blog post}.
}

