% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassCompoundDist.R
\docType{class}
\name{compoundNoEvtRefDist-class}
\alias{compoundNoEvtRefDist-class}
\alias{compoundNoEvtRefDist}
\title{An S4 class to represent a compound distribution.}
\description{
This S4 class describes the 'compound' distribution that is fitted to the marker values of patients that did not develop the event of interest in the reference treatment arm when the type of distribution is set to 'undefined' in the \code{fit} function.
}
\details{
You never have to create this class manually. This class is created internally when an undefined distribution is fitted on the marker values.
}
\section{Slots}{

\describe{
\item{\code{EvtRefDist}}{This slot is an object that describes the distribution of the marker for patients that developed the event in the reference arm. This object must be an "allowedDist" class object.}

\item{\code{EvtInnovDist}}{This slot is an object that describes the distribution of the marker for patients that developed the event in the innovative arm. This object must be an "allowedDist" class object.}

\item{\code{NoEvtInnovDist}}{This slot is an object that describes the distribution of the marker for patients that did not develop the event in the innovative arm. This object must be an "allowedDist" class object.}

\item{\code{r0}}{Mean risk of event occurrence in the reference arm. Numeric argument.}

\item{\code{r1}}{Mean risk of event occurrence in the innovative arm. Numeric argument.}
}}

\seealso{
\code{\link[optimalThreshold]{fit}} for more details on how to fit an undefined distribution.
}
