% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassTrtSelOptThresh.R, R/ClassDiagOptThresh.R
\docType{methods}
\name{decisionCurve}
\alias{decisionCurve}
\alias{decisionCurve,trtSelOptThresh-method}
\alias{decisionCurve.trtSelOptThresh}
\alias{decisionCurve,diagOptThresh-method}
\alias{decisionCurve.diagOptThresh}
\title{Decision curve plot}
\usage{
decisionCurve(object, r, ...)

\S4method{decisionCurve}{trtSelOptThresh}(object, r, alpha = 0.05)

\S4method{decisionCurve}{diagOptThresh}(object, r)
}
\arguments{
\item{object}{a \code{trtSelOptThresh} or a \code{diagOptThresh} S4 class object from which the decision curve must be plotted.}

\item{r}{Ratio of treatment/event costs (for treatment selection markers), or risk preference (for diagnostic marker). Numeric argument.}

\item{...}{other arguments passed to methods.}

\item{alpha}{alpha parameter for the confidence level required.}
}
\value{
Returns an object of class \code{trtSelRelUtility} if applied to a \code{trtSelOptThresh} object, and an object of class \code{diagRelUtility} if applied to a \code{diagOptThresh} object.
}
\description{
This S4 method allows to plot the decision curve associated with a treatment selection marker for several treatment/event cost ratios, or with a diagnostic marker for several risk thresholds.
}
\details{
This function plots the decision curves according to the type of marker under study (treatment selection or diagnostic) and the \code{r} argument. For treatment selection markers, it plots two graphs: the first one is a classical decision curves graph comparing the utilities of: the marker under study, the perfect marker, the strategy 'Treat everyone with the reference treatment', and the strategy 'Treat everyone with the innovative treatment'; the second one is the relative decision curve that plots the relative utility of the marker under study (0 meaning that using the marker to guide treatment decisions is not better than treating everyone with the overall best treatment, and 1 meaning that the marker under study has the same utility as the perfect marker). The decision curves are calculated using the mean risk of event in each treatment arm provided in the \code{trtSelOptThresh} object.
For diagnostic markers it calculates the expected benefit of the marker and compares it with the strategies "Treat everyone" and "Do not treat anyone". The decision curve is calculated for a population with a disease prevalence provided in the \code{diagOptThresh} object.
}
\section{References}{

Blangero, Y, Rabilloud, M, Ecochard, R, and Subtil, F. A Bayesian method to estimate the optimal threshold of a marker used to select patients' treatment. \emph{Statistical Methods in Medical Research}. 2019.
Huang, Y, Laber, EB, and Janes H. Characterizing expected benefits of biomarkers in treatment selection. \emph{Biostatistics}. 2015; 16(2): 383-399.
Vickers, AJ, and Elkin, EB. Decision curve analysis: a novel method for evaluating prediction models. \emph{Medical Decision Making}. 2006; 26(6): 565-574.
}

\seealso{
\code{\link[optimalThreshold]{trtSelThresh}} and \code{\link[optimalThreshold]{diagThresh}} for some examples on how to use this function.
}
