% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{optiongamma}
\alias{optiongamma}
\title{Option Gamma}
\usage{
optiongamma(s, x, sigma, t, r, d = 0)
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x}{Strike price of the option}

\item{sigma}{Implied volatility of the underlying asset price, defined as the annualized standard deviation of the asset returns}

\item{t}{Time to maturity in years}

\item{r}{Annual continuously-compounded risk-free rate, use the function r.cont}

\item{d}{Annual continuously-compounded dividend yield, use the function r.cont}
}
\value{
Returns the option gamma
}
\description{
Calculates the gamma of a European- style call and put option
}
\details{
Gamma is the rate of change of the option's delta given a $1 change in the underlying asset.
}
\examples{
optiongamma(100, 100, 0.20, (45/365), 0.02, 0.02)
}
