% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_funs.R
\name{cost_per_fish}
\alias{cost_per_fish}
\title{Compute the per-cost fish based on stocking time, time to recruitment,
growth, and mortality}
\usage{
cost_per_fish(
  time_at_stocking,
  time_at_rec,
  n_recruits_desired,
  cost_fun = total_cost,
  cost_fun_args,
  mort_fun = constant_mort,
  mort_fun_args
)
}
\arguments{
\item{time_at_stocking}{The time at which fish are stocked (i.e. synonymous
with the amount of time that fish are raised in a hatchery)}

\item{time_at_rec}{The time at which a fish enters the fishery (i.e. the
amount of time it takes a fish to grow to a desired length). Use
\code{\link{inv_vb}} to calculate this.}

\item{n_recruits_desired}{The number of recruits desired at
\code{time_at_rec}}

\item{cost_fun}{The cost function. Defaults to \code{\link{total_cost}}}

\item{cost_fun_args}{Arguments for \code{cost_fun}}

\item{mort_fun}{The mortality function, see ?mort_funs}

\item{mort_fun_args}{List. Named arguments to be passed to \code{mort_fun}}
}
\value{
The per-fish cost fish that lives until \code{time_at_rec} based on
\code{time_at_stocking}, the cost function and mortality functions.
}
\description{
Compute the per-cost fish based on stocking time, time to recruitment,
growth, and mortality
}
\examples{
cost_args <- list(
    init_cost = 0.05,
    time_slope = 0.01, time_exp = 1.2,
    rec_exp = 1
)
mort_args <- list(m_init = (1 / 365))
# the cost-per-fish to stock across a range of times given cost and mortality
# assumes fish recruit into the fishery at day 1000
curve(cost_per_fish(
    x, 1000, 1000,
    cost_fun_args = cost_args,
    mort_fun_args = mort_args),
  xlab = "Days", ylab = "$ per fish stocked",
  10, 1200
)
}
