% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{growth_parameters}
\alias{growth_parameters}
\title{Growth parameters for species used in examples}
\format{
A data.frame with 7 fields and 6 records:
\describe{
  \item{spp}{Species common name}
  \item{latin}{Scientific name for the species}
  \item{linf}{The L_infinity parameters for the VBGF}
  \item{k}{The k parameter for the VBGF}
  \item{t0}{The t_0 parameter for the VBGF}
  \item{n}{Number of samples used. For WDNR data this is the number of paired
    length-at-age data points (WDNR, 2021).
    For FishBase it is the number of submitted entries.
  }
  \item{source}{Where data was retrieved from. WDNR is the Wisconsin Dep't
    of Natural Resources Fisheries Management Database.
    FishBase (Froese and Pauly, 2010) is FishBase.
  }
}
}
\usage{
growth_parameters
}
\description{
This data.frame contains the growth parameters used in
\code{\link{spp_examples}}. The growth parameters correspond with the von
Bertalanfy growth curve (VBGF -- see \code{\link{vbgf}})
}
\keyword{datasets}
