% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{graph_from_bin}
\alias{graph_from_bin}
\title{Read the graph from a binary blob}
\usage{
graph_from_bin(path, bin, type = c("directed", "dag"))
}
\arguments{
\item{path}{(Optional) Path to a file containing a graph binary}

\item{bin}{(Optional) The raw binary of the graph}

\item{type}{The type of graph the JSON represents}
}
\value{
A graph object
}
\description{
Read the graph from a binary blob
}
\examples{
bin <- graph_builder() |>
  add_edge("A", "B") |>
  build_directed() |>
  graph_to_bin()
bin

graph_from_bin(bin = bin)
}
\seealso{
Other graphs i/o: 
\code{\link{graph_to_bin}()}
}
\concept{graphs i/o}
